package cn.com.duiba.order.center.biz.dao.activity.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.dao.activity.BaseActivityOrderDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by houwen on 16/7/25.
 */
@Repository("activityOrderDao")
public class ActivityOrderDaoImpl extends BaseActivityOrderDao implements ActivityOrderDao {

	@Resource
	private RemoteIDMakerService remoteIDMakerService;

	@Override
	public void insert(ActivityOrderEntity entity) {
		//TODO ID生成器类型
		DubboResult<Long> ret = remoteIDMakerService.getNextID(IDMakerTypeEnums.ACTIVITY_ORDER.getType());
		if (!ret.isSuccess()) {
			throw new RuntimeException("ID生成失败");
		}
		String suffix = getTableSuffix(entity.getConsumerId());
		String orderNum = ret.getResult() + "" + suffix;
		entity.setSuffix(suffix);
		entity.setOrderNum(orderNum);
		getSqlSession().insert(getStamentNameSpace("insert"), entity);
	}

	@Override
	public ActivityOrderEntity find(String orderNum) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("orderNum", orderNum);
		return getSqlSession().selectOne(getStamentNameSpace("find"), param);
	}

	@Override
	public int updateCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("consumeCreditsStatus", ActivityOrderDto.ConsumeCreditsSuccess);
		param.put("orderNum", orderNum);
		param.put("activityOptionId", activityOptionId);
		param.put("activityOptionName", activityOptionName);
		param.put("activityOptionType", activityOptionType);
		param.put("activityOptionFacePrice", activityOptionFacePrice);
		param.put("appItemId", appItemId);
		param.put("itemId", itemId);
		param.put("gid", gid);
		param.put("gtype", gtype);
		param.put("couponId", couponId);
		return getSqlSession().update(getStamentNameSpace("updateCreditsSuccess"), param);
	}

	@Override
	public int updateCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("consumeCreditsStatus", ActivityOrderDto.ConsumeCreditsFail);
		param.put("orderNum", orderNum);
		param.put("activityOptionId", activityOptionId);
		param.put("activityOptionName", activityOptionName);
		param.put("activityOptionType", activityOptionType);
		param.put("activityOptionFacePrice", activityOptionFacePrice);
		param.put("appItemId", appItemId);
		param.put("itemId", itemId);
		param.put("gid", gid);
		param.put("gtype", gtype);
		param.put("couponId", couponId);
		return getSqlSession().update(getStamentNameSpace("updateCreditsFail"), param);
	}

	@Override
	public int updateExchangeStatusWait(String orderNum) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("exchangeStatus", ActivityOrderDto.ExchangeWait);
		param.put("orderNum", orderNum);
		return getSqlSession().update(getStamentNameSpace("updateExchangeStatusWait"), param);
	}

	@Override
	public int updateExchangeStatusSuccess(String orderNum) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("exchangeStatus", ActivityOrderDto.ExchangeSuccess);
		param.put("orderNum", orderNum);
		return getSqlSession().update(getStamentNameSpace("updateExchangeStatusSuccess"), param);
	}

	@Override
	public int updateExchangeStatusFail(String orderNum) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("exchangeStatus", ActivityOrderDto.ExchangeFail);
		param.put("orderNum", orderNum);
		return getSqlSession().update(getStamentNameSpace("updateExchangeStatusFail"), param);
	}

	@Override
	public int updateExchangeStatusOverdue(String orderNum) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("exchangeStatus", ActivityOrderDto.ExchangeOverdue);
		param.put("orderNum", orderNum);
		return getSqlSession().update(getStamentNameSpace("updateExchangeStatusOverdue"), param);
	}

	@Override
	public int updateDeveloperBizId(String orderNum, String bizId) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("orderNum", orderNum);
		param.put("bizId", bizId);
		return getSqlSession().update(getStamentNameSpace("updateDeveloperBizId"), param);
	}

	@Override
	public int updateMainOrderNum(String orderNum, String mainOrderNum) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffixByOrderNum(orderNum));
		param.put("orderNum", orderNum);
		param.put("mainOrderNum", mainOrderNum);
		return getSqlSession().update(getStamentNameSpace("updateMainOrderNum"), param);
	}

	@Override
	public int countConsumerJoinNum(long consumerId, long duibaActivityId, String activityType) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffix(consumerId));
		param.put("duibaActivityId", duibaActivityId);
		param.put("consumerId", consumerId);
		param.put("activityType", activityType);
		return getSqlSession().selectOne(getStamentNameSpace("countConsumerJoinNum"), param);
	}

	@Override
	public List<ActivityOrderEntity> findConsumerJoinList(long consumerId, List<Long> duibaActivityIds, String activityType) {
		Map<String, Object> param = getBlankParams();
		param.put("suffix", getTableSuffix(consumerId));
		param.put("duibaActivityIds", duibaActivityIds);
		param.put("consumerId", consumerId);
		param.put("activityType", activityType);
		return getSqlSession().selectList(getStamentNameSpace("findConsumerJoinList"), param);
	}
	
}
