package cn.com.duiba.order.center.biz.service.activity;

import java.util.List;
import java.util.Map;

import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;

/**
 * Created by houwen on 16/7/25.
 */
public interface ActivityOrderService {
	
    /**
     * 创建活动订单
     * @param activityOrderDto
     * @return
     */
    public String createOrder(ActivityOrderEntity entity);
     
    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
	public ActivityOrderEntity findByOrderNum(String orderNum);
	
	/**
     * 订单扣积分成功
     * @param orderNum 订单唯一编号
     * @param optionDto 中奖奖项信息
     * @return
     */
    public boolean consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
     
    /**
     * 订单扣积分失败
     * @param orderNum 订单唯一编号
     * @param optionDto 奖项信息（如谢谢参与或空）
     * @return
     */
    public boolean consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
     
    /**
     * 订单置为待领奖状态
     * @param orderNum 订单唯一编号
     * @return
     */
    public boolean exchangeStatusToWait(String orderNum);
     
    /**
     * 订单置为领奖成功
     * @param orderNum 订单唯一编号
     * @return
     */
    public boolean exchangeStatusToSuccess(String orderNum);
     
    /**
     * 订单置为领奖失败
     * @param orderNum 订单唯一编号
     * @return
     */
    public boolean exchangeStatusToFail(String orderNum);
     
    /**
     * 订单置为未领奖过期
     * @param orderNum 订单唯一编号
     * @return
     */
    public boolean exchangeStatusToOverdue(String orderNum);
     
    /**
     * 根据订单唯一编号修改开发者订单号
     * @param orderNum 订单唯一编号
     * @param developerBizId 开发者订单号
     * @return
     */
    public boolean updateDeveloperBizId(String orderNum, String developerBizId);
    
    /**
     * 修改主订单号
     * @param orderNum 订单唯一编号
     * @param mainOrderNum 主订单唯一编号
     * @return
     */
    public boolean updateMainOrderNum(String orderNum, String mainOrderNum);
    
    /**
     * 用户参与兑吧活动次数
     * @param consumerId 用户ID
     * @param activityId 活动ID
     * @return
     */
    public Integer findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType);
    
    /**
     * 用户参与兑吧活动次数
     * @param consumerId 用户ID
     * @param duibaActivityIds 活动ID集合
     * @return List<Map<Long, Integer>>  key：活动ID, value:参与次数
     */
    public Map<Long, Integer> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType);
	
}
