package cn.com.duiba.order.center.biz.service.activity.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.service.activity.DataSyncActivityOrderService;
import cn.com.duiba.order.center.biz.service.activity.ActivityOrderService;

@Repository("activityOrderService")
public class ActivityOrderServiceImpl implements ActivityOrderService {

	@Autowired
	private ActivityOrderDao activityOrderDao;
	@Autowired
	private DataSyncActivityOrderService dataSyncActivityOrderService;

	@Override
	public String createOrder(ActivityOrderEntity entity) {
		activityOrderDao.insert(entity);
		dataSyncActivityOrderService.dataSync(entity.getOrderNum());
		return entity.getOrderNum();
	}

	@Override
	public ActivityOrderEntity findByOrderNum(String orderNum) {
		return activityOrderDao.find(orderNum);
	}

	@Override
	public boolean consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		int ret = activityOrderDao.updateCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		int ret = activityOrderDao.updateCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean exchangeStatusToWait(String orderNum) {
		int ret = activityOrderDao.updateExchangeStatusWait(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean exchangeStatusToSuccess(String orderNum) {
		int ret = activityOrderDao.updateExchangeStatusSuccess(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean exchangeStatusToFail(String orderNum) {
		int ret = activityOrderDao.updateExchangeStatusFail(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean exchangeStatusToOverdue(String orderNum) {
		int ret = activityOrderDao.updateExchangeStatusOverdue(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean updateDeveloperBizId(String orderNum, String developerBizId) {
		int ret = activityOrderDao.updateDeveloperBizId(orderNum, developerBizId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public boolean updateMainOrderNum(String orderNum, String mainOrderNum) {
		int ret = activityOrderDao.updateMainOrderNum(orderNum, mainOrderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	@Override
	public Integer findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType) {
		return activityOrderDao.countConsumerJoinNum(consumerId, duibaActivityId,activityType);
	}

	@Override
	public Map<Long, Integer> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType) {
		List<ActivityOrderEntity> orders = activityOrderDao.findConsumerJoinList(consumerId, duibaActivityIds,activityType);
		Map<Long, Integer> map = new HashMap<Long, Integer>();
		for (ActivityOrderEntity order : orders) {
			Integer num = map.get(order.getDuibaActivityId());
			num = num == null ? 1 : num + 1;
			map.put(order.getDuibaActivityId(), num);
		}
		return map;
	}

}
