package cn.com.duiba.order.center.biz.service.message;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.tool.KafkaClient;
import cn.com.duiba.pinellie.agent.PTransactions;

@Component
public class MessageService {

	private static Logger log = LoggerFactory.getLogger(MessageService.class);

	@Autowired
	private KafkaClient kafkaClient;
	@Autowired
	private TopicConstant topicConstant;

	private ExecutorService executorService = Executors.newFixedThreadPool(5, new ThreadFactory() {

		private int i = 0;

		@Override
		public Thread newThread(Runnable runnable) {
			return new Thread(runnable, "Thread-DataSync-" + (i++));
		}

	});

	public void sendMsg(final String queueName, final String body) {
		executorService.submit(new Runnable() {
			@Override
			public void run() {
				PTransactions transactions = PTransactions.newTransactions().build();
				try {
					Exception ex = null;
					for (int i = 0; i < 3; i++) {
						try {
							kafkaClient.sendMsg(queueName, body);
							// 记录业务指标，记录次数
							transactions.logMetricForCount("QUEUE-SUCCESS-ALL");
							transactions.logMetricForCount("QUEUE-" + queueName + "-SUCCESS");
							return;
						} catch (Exception e) {
							ex = e;
						}
					}
					if (ex != null) {
						transactions.logMetricForCount("QUEUE-ALL-FAIL");
						transactions.logMetricForCount("QUEUE-" + queueName + "-FAIL");
						log.error("sendMsg:queueName=" + queueName + ",body=" + body, ex);
					}
				} finally {
					transactions.complete();
				}

			}
		});
	}

}
