/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.dao.activity.impl;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.dao.activity.BaseActivityOrderDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository(value="activityOrderDao")
public class ActivityOrderDaoImpl
extends BaseActivityOrderDao
implements ActivityOrderDao {
    @Resource
    private RemoteIDMakerService remoteIDMakerService;

    @Override
    public void insert(ActivityOrderEntity entity) {
        DubboResult ret = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.ACTIVITY_ORDER.getType());
        if (!ret.isSuccess()) {
            throw new RuntimeException("ID\u751f\u6210\u5931\u8d25");
        }
        String suffix = this.getTableSuffix(entity.getConsumerId());
        String orderNum = ret.getResult() + "" + suffix;
        entity.setSuffix(suffix);
        entity.setOrderNum(orderNum);
        this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)entity);
    }

    @Override
    public ActivityOrderEntity find(String orderNum) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("orderNum", orderNum);
        return (ActivityOrderEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("find"), param);
    }

    @Override
    public int updateCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("consumeCreditsStatus", 2);
        param.put("orderNum", orderNum);
        param.put("activityOptionId", activityOptionId);
        param.put("activityOptionName", activityOptionName);
        param.put("activityOptionType", activityOptionType);
        param.put("activityOptionFacePrice", activityOptionFacePrice);
        param.put("appItemId", appItemId);
        param.put("itemId", itemId);
        param.put("gid", gid);
        param.put("gtype", gtype);
        param.put("couponId", couponId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateCreditsSuccess"), param);
    }

    @Override
    public int updateCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("consumeCreditsStatus", 3);
        param.put("orderNum", orderNum);
        param.put("activityOptionId", activityOptionId);
        param.put("activityOptionName", activityOptionName);
        param.put("activityOptionType", activityOptionType);
        param.put("activityOptionFacePrice", activityOptionFacePrice);
        param.put("appItemId", appItemId);
        param.put("itemId", itemId);
        param.put("gid", gid);
        param.put("gtype", gtype);
        param.put("couponId", couponId);
        param.put("error4admin", error4admin);
        param.put("error4developer", error4developer);
        param.put("error4consumer", error4consumer);
        return this.getSqlSession().update(this.getStamentNameSpace("updateCreditsFail"), param);
    }

    @Override
    public int updateExchangeStatusWait(String orderNum) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("exchangeStatus", 1);
        param.put("orderNum", orderNum);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExchangeStatusWait"), param);
    }

    @Override
    public int updateExchangeStatusSuccess(String orderNum) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("exchangeStatus", 2);
        param.put("orderNum", orderNum);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExchangeStatusSuccess"), param);
    }

    @Override
    public int updateExchangeStatusFail(String orderNum) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("exchangeStatus", 3);
        param.put("orderNum", orderNum);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExchangeStatusFail"), param);
    }

    @Override
    public int updateExchangeStatusOverdue(String orderNum) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("exchangeStatus", 4);
        param.put("orderNum", orderNum);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExchangeStatusOverdue"), param);
    }

    @Override
    public int updateDeveloperBizId(String orderNum, String bizId) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("orderNum", orderNum);
        param.put("bizId", bizId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateDeveloperBizId"), param);
    }

    @Override
    public int updateMainOrderNum(String orderNum, String mainOrderNum) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffixByOrderNum(orderNum));
        param.put("orderNum", orderNum);
        param.put("mainOrderNum", mainOrderNum);
        return this.getSqlSession().update(this.getStamentNameSpace("updateMainOrderNum"), param);
    }

    @Override
    public int countConsumerJoinNum(long consumerId, long duibaActivityId, String activityType) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffix(consumerId));
        param.put("duibaActivityId", duibaActivityId);
        param.put("consumerId", consumerId);
        param.put("activityType", activityType);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countConsumerJoinNum"), param);
    }

    @Override
    public List<ActivityOrderEntity> findConsumerJoinList(long consumerId, List<Long> duibaActivityIds, String activityType) {
        Map<String, Object> param = this.getBlankParams();
        param.put("suffix", this.getTableSuffix(consumerId));
        param.put("duibaActivityIds", duibaActivityIds);
        param.put("consumerId", consumerId);
        param.put("activityType", activityType);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findConsumerJoinList"), param);
    }
}

