/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.activity.impl;

import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.service.activity.ActivityOrderService;
import cn.com.duiba.order.center.biz.service.activity.DataSyncActivityOrderService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="activityOrderService")
public class ActivityOrderServiceImpl
implements ActivityOrderService {
    @Autowired
    private ActivityOrderDao activityOrderDao;
    @Autowired
    private DataSyncActivityOrderService dataSyncActivityOrderService;

    @Override
    public String createOrder(ActivityOrderEntity entity) {
        this.activityOrderDao.insert(entity);
        this.dataSyncActivityOrderService.dataSync(entity.getOrderNum());
        return entity.getOrderNum();
    }

    @Override
    public ActivityOrderEntity findByOrderNum(String orderNum) {
        return this.activityOrderDao.find(orderNum);
    }

    @Override
    public boolean consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        int ret = this.activityOrderDao.updateCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.activityOrderDao.updateCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean exchangeStatusToWait(String orderNum) {
        int ret = this.activityOrderDao.updateExchangeStatusWait(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean exchangeStatusToSuccess(String orderNum) {
        int ret = this.activityOrderDao.updateExchangeStatusSuccess(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean exchangeStatusToFail(String orderNum) {
        int ret = this.activityOrderDao.updateExchangeStatusFail(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean exchangeStatusToOverdue(String orderNum) {
        int ret = this.activityOrderDao.updateExchangeStatusOverdue(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean updateDeveloperBizId(String orderNum, String developerBizId) {
        int ret = this.activityOrderDao.updateDeveloperBizId(orderNum, developerBizId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public boolean updateMainOrderNum(String orderNum, String mainOrderNum) {
        int ret = this.activityOrderDao.updateMainOrderNum(orderNum, mainOrderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    @Override
    public Integer findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType) {
        return this.activityOrderDao.countConsumerJoinNum(consumerId, duibaActivityId, activityType);
    }

    @Override
    public List<ActivityOrderEntity> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType) {
        return this.activityOrderDao.findConsumerJoinList(consumerId, duibaActivityIds, activityType);
    }
}

