/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.activity.center.api.remoteservice.hdtool.RemoteDuibaHdtoolServiceNew;
import cn.com.duiba.activity.center.api.remoteservice.singlelottery.RemoteDuibaSingleLotteryServiceNew;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerExtraDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.remoteservice.RemoteAppItemService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerExtraService;
import cn.com.duiba.service.remoteservice.RemoteItemService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataToolService {
    @Autowired
    private RemoteAppItemService remoteAppItemService;
    @Autowired
    private RemoteItemService remoteItemService;
    @Autowired
    private RemoteConsumerExtraService remoteConsumerExtraService;
    @Autowired
    private RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;
    @Autowired
    private RemoteDuibaHdtoolServiceNew remoteDuibaHdtoolServiceNew;
    @Autowired
    private RemoteDuibaSingleLotteryServiceNew remoteDuibaSingleLotteryServiceNew;
    @Autowired
    private RemoteAppService remoteAppService;

    public List<AppItemDO> getAppItemListByOrderList(List<OrdersDto> orders) {
        if (orders == null) {
            return null;
        }
        if (orders.isEmpty()) {
            return Collections.emptyList();
        }
        List result = null;
        ArrayList<Long> aiIds = new ArrayList<Long>();
        for (OrdersDto o : orders) {
            if (o.getAppItemId() == null) continue;
            aiIds.add(o.getAppItemId());
        }
        result = aiIds.size() > 0 ? this.remoteAppItemService.findAllByIds(aiIds) : Collections.emptyList();
        return result;
    }

    public Map<Long, AppItemDO> getAppItemMapByOrderList(List<OrdersDto> orders) {
        List<AppItemDO> appItems = this.getAppItemListByOrderList(orders);
        if (appItems == null) {
            return null;
        }
        if (appItems.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, AppItemDO> appItemMap = new HashMap<Long, AppItemDO>();
        for (AppItemDO a : appItems) {
            appItemMap.put(a.getId(), a);
        }
        return appItemMap;
    }

    public List<ItemDO> getItemListByOrderList(List<OrdersDto> orders) {
        if (orders == null) {
            return null;
        }
        if (orders.isEmpty()) {
            return Collections.emptyList();
        }
        List result = null;
        ArrayList<Long> iIds = new ArrayList<Long>();
        for (OrdersDto o : orders) {
            if (o.getItemId() == null) continue;
            iIds.add(o.getItemId());
        }
        result = iIds.size() > 0 ? this.remoteItemService.findAllByIds(iIds) : Collections.emptyList();
        return result;
    }

    public Map<Long, ItemDO> getItemMapByOrderList(List<OrdersDto> orders) {
        List<ItemDO> items = this.getItemListByOrderList(orders);
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, ItemDO> itemMap = new HashMap<Long, ItemDO>();
        for (ItemDO a : items) {
            itemMap.put(a.getId(), a);
        }
        return itemMap;
    }

    public List<ConsumerExtraDO> getConsumerExtraListByOrderList(List<OrdersDto> orders) {
        if (orders == null) {
            return null;
        }
        if (orders.isEmpty()) {
            return Collections.emptyList();
        }
        List result = null;
        ArrayList<Long> ceIds = new ArrayList<Long>();
        for (OrdersDto o : orders) {
            if (o.getConsumerId() == null) continue;
            ceIds.add(o.getConsumerId());
        }
        result = ceIds.size() > 0 ? this.remoteConsumerExtraService.findAllByConsumerIds(ceIds) : Collections.emptyList();
        return result;
    }

    public Map<Long, ConsumerExtraDO> getConsumerExtraMapByOrderList(List<OrdersDto> orders) {
        List<ConsumerExtraDO> ces = this.getConsumerExtraListByOrderList(orders);
        if (ces == null) {
            return null;
        }
        if (ces.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, ConsumerExtraDO> ceMap = new HashMap<Long, ConsumerExtraDO>();
        for (ConsumerExtraDO a : ces) {
            ceMap.put(a.getConsumerId(), a);
        }
        return ceMap;
    }

    public List<OperatingActivityDto> getOperatingActivityListByOrderList(List<OrdersDto> orders) {
        if (orders == null) {
            return null;
        }
        if (orders.isEmpty()) {
            return Collections.emptyList();
        }
        List result = null;
        ArrayList<Long> reIds = new ArrayList<Long>();
        for (OrdersDto o : orders) {
            if (o.getRelationId() == null) continue;
            reIds.add(o.getRelationId());
        }
        result = reIds.size() > 0 ? this.remoteOperatingActivityServiceNew.findAllByIds(reIds) : Collections.emptyList();
        return result;
    }

    public Map<Long, OperatingActivityDto> getOperatingActivityMapByOrderList(List<OrdersDto> orders) {
        List<OperatingActivityDto> oas = this.getOperatingActivityListByOrderList(orders);
        if (oas == null) {
            return null;
        }
        if (oas.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, OperatingActivityDto> reMap = new HashMap<Long, OperatingActivityDto>();
        for (OperatingActivityDto a : oas) {
            reMap.put(a.getId(), a);
        }
        return reMap;
    }

    public Map<Long, ItemDO> getItemMapByIdList(List<Long> ids) {
        List itemList = null;
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        itemList = this.remoteItemService.findAllByIds(ids);
        HashMap<Long, ItemDO> itemMap = new HashMap<Long, ItemDO>();
        for (ItemDO i : itemList) {
            itemMap.put(i.getId(), i);
        }
        return itemMap;
    }

    public Map<Long, DuibaSingleLotteryDto> getDuibaSingleLotteryMapByIdList(List<Long> ids) {
        List dslList = null;
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        dslList = this.remoteDuibaSingleLotteryServiceNew.findAllByIds(ids);
        HashMap<Long, DuibaSingleLotteryDto> dslMap = new HashMap<Long, DuibaSingleLotteryDto>();
        for (DuibaSingleLotteryDto d : dslList) {
            dslMap.put(d.getId(), d);
        }
        return dslMap;
    }

    public Map<Long, DuibaHdtoolDto> getDuibaHdtoolMapByIdList(List<Long> ids) {
        List dhList = null;
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        dhList = this.remoteDuibaHdtoolServiceNew.findAllByIds(ids);
        HashMap<Long, DuibaHdtoolDto> dhMap = new HashMap<Long, DuibaHdtoolDto>();
        for (DuibaHdtoolDto d : dhList) {
            dhMap.put(d.getId(), d);
        }
        return dhMap;
    }

    public Map<Long, AppDO> getAppMapByIdList(List<Long> ids) {
        List appList = null;
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        appList = this.remoteAppService.findByIds(ids);
        HashMap<Long, AppDO> appMap = new HashMap<Long, AppDO>();
        for (AppDO i : appList) {
            appMap.put(i.getId(), i);
        }
        return appMap;
    }
}

