/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.order.center.api.dto.flowwork.FlowworkStage;
import cn.com.duiba.order.center.api.dto.flowwork.NodeSubStatus;
import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.amb.RemoteAmbOrderFastService;
import cn.com.duiba.order.center.api.remoteservice.amb.RemoteAmbSettledService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteAfterSendFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteConsumeCreditsFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteCreateFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteDeveloperPayFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteFailFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteOrderEngineService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteSuccessFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.flowwork.RemoteSupplierExchangeFlowWorkerService;
import cn.com.duiba.order.center.api.remoteservice.orders.consumer.RemoteOrdersSimpleService;
import cn.com.duiba.order.center.api.remoteservice.orders.mirror.RemoteMasterOrdersMirrorSimpleService;
import cn.com.duiba.order.center.api.utils.FlowworkTool;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.OrderSyncBo;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrdersExceptionDataBo {
    private static Logger log = LoggerFactory.getLogger(OrdersExceptionDataBo.class);
    @Autowired
    private RemoteMasterOrdersMirrorSimpleService remoteMasterOrdersMirrorSimpleService;
    @Autowired
    private RemoteOrdersSimpleService remoteOrdersSimpleService;
    @Autowired
    private RemoteCreateFlowWorkerService remoteCreateFlowWorkerService;
    @Autowired
    private RemoteOrderEngineService remoteOrderEngineService;
    @Autowired
    private OrderSyncBo orderSyncService;
    @Autowired
    private RemoteSuccessFlowWorkerService remoteSuccessFlowWorkerService;
    @Autowired
    private RemoteConsumeCreditsFlowWorkerService remoteConsumeCreditsFlowWorkerService;
    @Autowired
    private RemoteAfterSendFlowWorkerService remoteAfterSendFlowWorkerService;
    @Autowired
    private RemoteDeveloperPayFlowWorkerService remoteDeveloperPayFlowWorkerService;
    @Autowired
    private RemoteFailFlowWorkerService remoteFailFlowWorkerService;
    @Autowired
    OrderReadManagerBo orderReadManager;
    @Autowired
    RemoteAmbOrderFastService ambOrderFastService;
    @Autowired
    RemoteAmbSettledService ambSettledService;
    @Autowired
    RemoteSupplierExchangeFlowWorkerService remoteSupplierExchangeFlowWorkerService;

    public void process(long offset, Long li) {
        long limit = 3000L;
        Long count = this.remoteMasterOrdersMirrorSimpleService.findOffsetLimtCount();
        if (null != li) {
            limit = li;
            count = li;
        }
        log.error("current count is : " + count);
        if (null != count) {
            long k = count / limit;
            for (long i = 0L; i <= k; ++i) {
                List lists = this.remoteMasterOrdersMirrorSimpleService.findOffsetLimt(Long.valueOf(i * limit), Long.valueOf(limit));
                if (null == lists) continue;
                log.error("=============================  K " + i + "KKKKKKKK " + k + "size " + lists.size());
                for (OrdersDto order : lists) {
                    OrdersDto or = this.remoteOrdersSimpleService.find(order.getId(), order.getConsumerId());
                    if (null == or) continue;
                    this.orderSyncService.sync(or.getId(), or.getConsumerId());
                    log.error("process data is OrderID: " + or.getId() + "   consumerID: " + or.getConsumerId());
                    FlowworkStage stage = FlowworkTool.getStage((OrdersDto)((OrdersDto)BeanUtils.copy((Object)or, OrdersDto.class)));
                    if (stage.nodeSubStatus == NodeSubStatus.Complete && stage.nodeType == NodeType.AfterSend) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Complete && stage.nodeType == NodeType.Audit) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Started && stage.nodeType == NodeType.ConsumeCredits) {
                        try {
                            this.remoteConsumeCreditsFlowWorkerService.forceMakeTofail(or.getId(), or.getConsumerId());
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Tofail && stage.nodeType == NodeType.ConsumeCredits) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Complete && stage.nodeType == NodeType.ConsumerPay) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Tofail && stage.nodeType == NodeType.ConsumerPay) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Started && stage.nodeType == NodeType.Create) {
                        try {
                            this.remoteCreateFlowWorkerService.forceMakeTofail(or.getId(), or.getConsumerId());
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Complete && stage.nodeType == NodeType.Create) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Started && stage.nodeType == NodeType.DeveloperPay) {
                        try {
                            this.remoteDeveloperPayFlowWorkerService.forceMakeFail(or.getId(), or.getConsumerId());
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Complete && stage.nodeType == NodeType.DuibaPay) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Complete && stage.nodeType == NodeType.Fail) {
                        try {
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Started && stage.nodeType == NodeType.Fail) {
                        try {
                            this.remoteFailFlowWorkerService.makeFail(or.getId(), or.getConsumerId());
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus == NodeSubStatus.Started && stage.nodeType == NodeType.Success) {
                        try {
                            this.remoteSuccessFlowWorkerService.makeSuccess(or.getId(), or.getConsumerId());
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                        }
                        catch (Exception e) {
                            log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                        }
                    }
                    if (stage.nodeSubStatus != NodeSubStatus.Started || stage.nodeType != NodeType.AfterSend) continue;
                    try {
                        if (or.getConsumerPayPrice() != 0L) continue;
                        this.remoteAfterSendFlowWorkerService.markAfterSend2Complete(or.getId(), or.getConsumerId());
                        this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                        this.orderSyncService.sync(or.getId(), or.getConsumerId());
                    }
                    catch (Exception e) {
                        log.error("force Make fail is error orderID: " + order.getId() + "  consumerID: " + order.getConsumerId(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void dataSync(Long li) {
        long limit = 3000L;
        Long count = this.remoteMasterOrdersMirrorSimpleService.findDataSyncCount();
        if (null != li) {
            limit = li;
            count = li;
        }
        log.error("current count is : " + count);
        if (null != count) {
            long k = count / limit;
            for (long i = 0L; i <= k; ++i) {
                List lists = this.remoteMasterOrdersMirrorSimpleService.findDataSyncLimt(Long.valueOf(i * limit), Long.valueOf(limit));
                if (null == lists) continue;
                log.error("=============================  K " + i + "KKKKKKKK " + k + "size " + lists.size());
                for (OrdersDto order : lists) {
                    OrdersDto or = this.remoteOrdersSimpleService.find(order.getId(), order.getConsumerId());
                    if (null == or) continue;
                    this.orderSyncService.sync(or.getId(), or.getConsumerId());
                    log.error("process data is OrderID: " + or.getId() + "   consumerID: " + or.getConsumerId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSupplierFail(Long offset, Long li) {
        long limit = 3000L;
        Long count = this.remoteMasterOrdersMirrorSimpleService.findOffsetLimtCount();
        if (null != li) {
            limit = li;
            count = li;
        }
        log.error("current count is : " + count);
        if (null != count) {
            long k = count / limit;
            for (long i = 0L; i <= k; ++i) {
                Long off = i * limit + offset;
                List lists = this.remoteMasterOrdersMirrorSimpleService.findOffsetLimt(off, Long.valueOf(limit));
                if (null == lists) continue;
                log.error("=============================  K " + i + "KKKKKKKK " + k + "size " + lists.size());
                for (OrdersDto order : lists) {
                    OrdersDto or = this.remoteOrdersSimpleService.find(order.getId(), order.getConsumerId());
                    if (null != or && or.getStatus() != "success" && or.getStatus() != "fail" && !"hdtool".equals(or.getChargeMode())) {
                        try {
                            log.error("process data is OrderID: " + or.getId() + "   consumerID: " + or.getConsumerId());
                            this.remoteSupplierExchangeFlowWorkerService.mngForceSupplierFail(or.getId(), or.getConsumerId());
                            this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
                            continue;
                        }
                        catch (Exception e) {
                            log.error("data process error", (Throwable)e);
                            continue;
                        }
                        finally {
                            this.orderSyncService.sync(or.getId(), or.getConsumerId());
                            continue;
                        }
                    }
                    log.error("status :  " + or.getStatus() + or.getId() + "   consumerID: " + or.getConsumerId() + "  flowworkEngine " + or.getFlowworkStage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSupplierFailByOrderId(Long orderId, Long consumerId) {
        OrdersDto or = this.remoteOrdersSimpleService.find(orderId, consumerId);
        if (null != or && or.getStatus() != "success" && or.getStatus() != "fail") {
            try {
                this.remoteSupplierExchangeFlowWorkerService.mngForceSupplierFail(or.getId(), or.getConsumerId());
                this.remoteOrderEngineService.go(or.getId(), or.getConsumerId());
            }
            catch (Exception e) {
                log.error("data process error", (Throwable)e);
            }
            finally {
                this.orderSyncService.sync(or.getId(), or.getConsumerId());
            }
        } else {
            log.error("status :  " + or.getStatus() + or.getId() + "   consumerID: " + or.getConsumerId() + "  flowworkEngine " + or.getFlowworkStage());
        }
    }

    public void orderSettled(Long orderId, Long consumerId) {
        OrdersDto order = this.orderReadManager.find(orderId, consumerId);
        if (order.getConsumerPayPrice() > 0L) {
            try {
                this.ambOrderFastService.removeOrderFastAtFinish(order.getId());
                this.ambSettledService.ambSettled(order.getId(), order.getConsumerId());
            }
            catch (Exception e) {
                log.error("\u52a0\u94b1\u8d2d\u7ed3\u7b97\u51fa\u73b0\u5f02\u5e38    orderId=" + order.getId(), (Throwable)e);
            }
        } else {
            log.error("not amb order  ");
        }
    }
}

