/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.IntegerTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TodayActivityStatisticsService {
    private static Logger log = LoggerFactory.getLogger(TodayActivityStatisticsService.class);
    private final String OPERATING_ACTIVITY = "operating_activity_";
    public static final String TURNTABLE = "turntable";
    public static final String SINGLE_LOTTERY = "single_lottery";
    public static final String HDTOOL = "hdtool";
    @Autowired
    private MemcachedClient memcachedClient;

    public void addTodayConsumeCredits(Long operatingActivityId, Long credits) {
        if (credits != null && operatingActivityId != null) {
            try {
                String creditsKey = "operating_activity_" + operatingActivityId + "_credits";
                if (this.setByCas(creditsKey, credits.intValue(), 1) == 2) {
                    this.memcachedClient.set(creditsKey, DateUtils.getToTomorrowSeconds(), (Object)credits.intValue());
                }
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u6d88\u8017\u79ef\u5206\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void rollbackTodayConsumeCredits(Long operatingActivityId, Long credits) {
        if (credits != null && operatingActivityId != null) {
            try {
                String creditsKey = "operating_activity_" + operatingActivityId + "_credits";
                this.setByCas(creditsKey, credits.intValue(), -1);
            }
            catch (Exception e) {
                log.error("\u56de\u6eda\u6d88\u8017\u79ef\u5206\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void addTodayWinCount(Long operatingActivityId) {
        if (operatingActivityId != null) {
            try {
                String winCountKey = "operating_activity_" + operatingActivityId + "_winCount";
                if (this.setByCas(winCountKey, 1, 1) == 2) {
                    this.memcachedClient.set(winCountKey, DateUtils.getToTomorrowSeconds(), (Object)1);
                }
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u5f53\u65e5\u4e2d\u5956\u4eba\u6b21\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void addTodayOrderCount(Long operatingActivityId) {
        if (operatingActivityId != null) {
            try {
                String orderCountKey = "operating_activity_" + operatingActivityId + "_orderCount";
                if (this.setByCas(orderCountKey, 1, 1) == 2) {
                    this.memcachedClient.set(orderCountKey, DateUtils.getToTomorrowSeconds(), (Object)1);
                }
            }
            catch (Exception e) {
                log.error("\u589e\u52a0\u5f53\u65e5\u6d3b\u52a8\u8ba2\u5355\u6570\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private Integer setByCas(String key, int value, int type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    nextValue += value;
                } else if (type < 0) {
                    nextValue = nextValue >= value ? (nextValue -= value) : 0;
                } else {
                    loop = false;
                    result = 4;
                    break;
                }
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtils.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new IntegerTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
            log.error("\u66f4\u65b0\u7f13\u5b58\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }
}

