/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbOrderFastDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.service.amb.AmbOrderFastService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AmbOrderFastBoImpl
implements AmbOrderFastBo {
    @Autowired
    private AmbOrderFastService ambOrderFastService;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;

    @Override
    public int createOrderFastWaitPay(Long orderId, Long consumerId, Date orderGmtCreate) {
        Date scanTime = DateUtils.minutesAddOrSub((Date)orderGmtCreate, (int)AmbOrderFastDto.ScanTime30Minute);
        return this.innerCreateOrderFast(orderId, consumerId, "wait_pay", scanTime);
    }

    @Override
    public int createOrderFastWaitReceive(Long orderId, Long consumerId) {
        Date scanTime = DateUtils.daysAddOrSub((Date)new Date(), (int)AmbOrderFastDto.ScanTime7Day);
        return this.innerCreateOrderFast(orderId, consumerId, "wait_receive", scanTime);
    }

    @Override
    public int createOrderFastReceived(Long orderId, Long consumerId) {
        Date scanTime = DateUtils.daysAddOrSub((Date)new Date(), (int)AmbOrderFastDto.ScanTime7Day);
        return this.innerCreateOrderFast(orderId, consumerId, "received", scanTime);
    }

    @Override
    public int createOrderFastWaitPostsale(Long orderId, Long consumerId) {
        Date scanTime = DateUtils.daysAddOrSub((Date)new Date(), (int)AmbOrderFastDto.ScanTime7Day);
        return this.innerCreateOrderFast(orderId, consumerId, "wait_postsale", scanTime);
    }

    @Override
    public int createOrderFastAfterAgree(Long orderId, Long consumerId) {
        Date scanTime = DateUtils.daysAddOrSub((Date)new Date(), (int)AmbOrderFastDto.ScanTime14Day);
        return this.innerCreateOrderFast(orderId, consumerId, "after_agree", scanTime);
    }

    @Override
    public int createOrderFastMaxTime(Long orderId, Long consumerId) {
        Date scanTime = DateUtils.daysAddOrSub((Date)new Date(), (int)AmbOrderFastDto.ScanTime60Day);
        return this.innerCreateOrderFast(orderId, consumerId, "max_time", scanTime);
    }

    @Override
    public int removeOrderFastWaitPay(Long orderId) {
        return this.ambOrderFastService.deleteByTypeAndOrderId(orderId, "wait_pay");
    }

    @Override
    public int removeOrderFastWaitReceive(Long orderId) {
        return this.ambOrderFastService.deleteByTypeAndOrderId(orderId, "wait_receive");
    }

    @Override
    public int removeOrderFastReceived(Long orderId) {
        return this.ambOrderFastService.deleteByTypeAndOrderId(orderId, "received");
    }

    @Override
    public int removeOrderFastWaitPostsale(Long orderId) {
        return this.ambOrderFastService.deleteByTypeAndOrderId(orderId, "wait_postsale");
    }

    @Override
    public int removeOrderFastAfterAgree(Long orderId) {
        return this.ambOrderFastService.deleteByTypeAndOrderId(orderId, "after_agree");
    }

    @Override
    public int removeOrderFastMaxTime(Long orderId) {
        return this.ambOrderFastService.deleteByTypeAndOrderId(orderId, "max_time");
    }

    @Override
    public int removeOrderFastAtFinish(Long orderId) {
        return this.ambOrderFastService.deleteByOrderId(orderId);
    }

    private int innerCreateOrderFast(Long orderId, Long consumerId, String orderFastType, Date scanTime) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        AmbOrderFastDto fast = new AmbOrderFastDto();
        fast.setConsumerId(order.getConsumerId());
        fast.setOrderId(order.getId());
        fast.setAppId(order.getAppId());
        fast.setAmbSubOrderId(order.getSubOrderId());
        fast.setOrderFastType(orderFastType);
        fast.setScanTime(scanTime);
        return this.ambOrderFastService.insert(fast);
    }

    @Override
    public AmbOrderFastDto lock(Long id) {
        return this.ambOrderFastService.findForUpdate(id);
    }

    @Override
    public AmbOrderFastDto findByOrderIdAndType(Long orderId, String type) {
        return this.ambOrderFastService.findByOrderIdAndType(orderId, type);
    }
}

