/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbAlipayPaybackDto;
import cn.com.duiba.order.center.api.dto.amb.AmbPaychannelOrdersDto;
import cn.com.duiba.order.center.api.dto.amb.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPaybackBo;
import cn.com.duiba.order.center.biz.service.amb.AmbAlipayPaybackService;
import cn.com.duiba.order.center.biz.service.amb.AmbPaychannelOrdersService;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import cn.com.duiba.paycenter.client.AmbPayCenterServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.result.AmbResult;
import cn.com.duiba.paycenter.service.AmbPayCenterService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class AmbPaybackBoImpl
implements AmbPaybackBo {
    private static Logger log = LoggerFactory.getLogger(AmbPaybackBoImpl.class);
    @Autowired
    private AmbAlipayPaybackService ambAlipayPaybackService;
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;
    @Autowired
    private AmbPaychannelOrdersService ambPaychannelOrdersService;
    @Autowired
    private AmbPayCenterServiceClient ambPayCenterServiceClient;
    @Resource
    private PlatformTransactionManager creditsMasterTransactionManager;

    @Override
    @Transactional(value="credits")
    public void createPayBackRecordAtMakeFail(OrdersDto orders) throws Exception {
        AmbAlipayPaybackDto payback;
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.creditsMasterTransactionManager.getTransaction((TransactionDefinition)def);
        AmbSubOrdersDto sub = this.ambSubOrdersService.findSubOrderById(orders.getSubOrderId());
        try {
            this.ambSubOrdersService.updateSettleStatusNoneBySubId(orders.getSubOrderId(), orders.getConsumerPayPrice());
            this.ambOrderFastBo.removeOrderFastAtFinish(orders.getId());
        }
        catch (Exception e) {
            status.setRollbackOnly();
            log.error("createPayBackRecordAtMakeFail:" + e);
            throw e;
        }
        finally {
            this.creditsMasterTransactionManager.commit(status);
        }
        if (null == sub.getAmbPaychannelOrdersId()) {
            return;
        }
        AmbPaychannelOrdersDto channel = this.ambPaychannelOrdersService.findById(sub.getAmbPaychannelOrdersId());
        if (null == channel || !"success".equals(channel.getStatus())) {
            return;
        }
        this.ambPaychannelOrdersService.updatePayBackMoneyByIdAndStatusSuccess(channel.getId(), orders.getConsumerPayPrice());
        if ("alipay".equals(channel.getPaychannelType())) {
            AmbPaychannelOrdersDto channelOrder = this.ambPaychannelOrdersService.findById(sub.getAmbPaychannelOrdersId());
            payback = new AmbAlipayPaybackDto();
            payback.setAmbPaychannelOrderId(sub.getAmbPaychannelOrdersId());
            payback.setAmbSubOrderId(sub.getId());
            payback.setOrderId(orders.getId());
            payback.setTradeNo(channelOrder.getTradeNum());
            payback.setRefundPrice(orders.getConsumerPayPrice());
            if ("reject".equals(orders.getAuditStatus())) {
                payback.setReason("\u5ba1\u6838\u62d2\u7edd");
            } else {
                payback.setReason("\u53d1\u8d27\u53d6\u6d88");
            }
        } else {
            log.error("");
            throw new Exception("\u652f\u4ed8\u7c7b\u578b\u6709\u8bef");
        }
        payback.setOrderNum(orders.getOrderNum());
        payback.setStatus("wait");
        this.ambAlipayPaybackService.createAlipayPayBackRecord(payback);
        try {
            this.payCenterComsumerPayBack(orders, sub);
        }
        catch (Exception e) {
            log.error("\u5411\u652f\u4ed8\u4e2d\u5fc3  \u53d1\u8d77\u9000\u6b3e\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void createPayBackRecordAtPaySuccess(OrdersDto orders) throws Exception {
        AmbSubOrdersDto sub = this.ambSubOrdersService.findSubOrderById(orders.getSubOrderId());
        AmbPaychannelOrdersDto channel = this.ambPaychannelOrdersService.findById(sub.getAmbPaychannelOrdersId());
        if (!"alipay".equals(channel.getPaychannelType())) {
            throw new Exception("\u652f\u4ed8\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        AmbAlipayPaybackDto payback = new AmbAlipayPaybackDto();
        payback.setAmbPaychannelOrderId(sub.getAmbPaychannelOrdersId());
        payback.setAmbSubOrderId(sub.getId());
        payback.setOrderId(orders.getId());
        payback.setTradeNo(channel.getTradeNum());
        payback.setRefundPrice(orders.getConsumerPayPrice());
        payback.setReason("\u52a0\u901f\u8868\u4e2d\u4e0d\u5b58\u5728wait_pay\u72b6\u6001\u7684\u5b9a\u5355\u8bb0\u5f55\uff0c\u76f4\u63a5\u8fd8\u6b3e\uff0c\u53ef\u80fd\u662f30\u5206\u949f\u652f\u4ed8\u8d85\u65f6\uff01 ");
        payback.setOrderNum(orders.getOrderNum());
        payback.setStatus("wait");
        this.ambAlipayPaybackService.createAlipayPayBackRecord(payback);
        try {
            this.payCenterComsumerPayBack(orders, sub);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
        }
    }

    private void payCenterComsumerPayBack(OrdersDto order, AmbSubOrdersDto sub) throws Exception {
        AmbPayCenterService.AmbPayParams payParams = new AmbPayCenterService.AmbPayParams();
        payParams.setConusmerId(order.getConsumerId());
        payParams.setAppId(order.getAppId());
        payParams.setOrdersSource(sub.getOrdersSource());
        Long developerId = order.getDeveloperId();
        Long orderId = order.getId();
        Long consumerPrice = order.getConsumerPayPrice();
        RpcResult result = this.ambPayCenterServiceClient.consumerPayBack(developerId, orderId, consumerPrice, payParams);
        if (!result.isOpSuccess()) {
            PayCenterLog.info("ambPayCenterServiceClient.consumerPayBack exception developer_id " + developerId + " orderId " + orderId + " consumerPrice " + consumerPrice, (Throwable)result.getRpcException());
            for (int i = 0; i < OrdersDto.try_again_count; ++i) {
                Uninterruptibles.sleepUninterruptibly((long)OrdersDto.try_again_interval_time.intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                result = this.ambPayCenterServiceClient.consumerPayBack(developerId, orderId, consumerPrice, payParams);
                if (result.isOpSuccess()) break;
                PayCenterLog.info("call ambPayCenterServiceClient.consumerPayBack exception developId: " + developerId + " try again " + i + ",orderId " + orderId);
            }
            if (!result.isOpSuccess()) {
                PayCenterLog.info("call ambPayCenterServiceClient.consumerPayBack exception   developId: " + developerId + ",orderId " + orderId, (Throwable)result.getRpcException());
                String remark = sub.getRemark();
                remark = "consumerPay\u7528\u6237\u652f\u4ed8\u6210\u529f\u540e\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\uff0c\u7f51\u7edc\u5f02\u5e38\uff01  " + remark;
                this.ambSubOrdersService.updateRemarkBySubId(sub.getId(), remark);
                throw new Exception("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\uff0c\u7f51\u7edc\u5f02\u5e38");
            }
        }
        if (result.isOpSuccess() && !((AmbResult)result.getResult()).isBizSuccess()) {
            PayCenterLog.info("ambPayCenterServiceClient.consumerPayBack is finall failed  developId: " + developerId + ",orderId " + orderId, ((AmbResult)result.getResult()).getErrorException());
            String remark = sub.getRemark();
            remark = "consumerPay\u7528\u6237\u652f\u4ed8\u6210\u529f\u540e\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\uff0c\u652f\u4ed8\u4e2d\u5fc3\u53cd\u9988\u5931\u8d25\uff01  " + remark;
            this.ambSubOrdersService.updateRemarkBySubId(sub.getId(), remark);
            throw new Exception("\u8c03\u7528 \u652f\u4ed8\u4e2d\u5fc3\uff0c\u53cd\u9988\u5931\u8d25");
        }
    }
}

