/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.amb.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPostsaleBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPostsaleOrderFasterBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPostsaleOrdersBo;
import cn.com.duiba.order.center.biz.service.amb.AmbPostsaleOrdersService;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="ambPostsaleService")
public class AmbPostsaleBoImpl
implements AmbPostsaleBo {
    private static Logger log = LoggerFactory.getLogger(AmbPostsaleBoImpl.class);
    @Autowired
    private AmbPostsaleOrderFasterBo ambPostsaleOrderFasterBo;
    @Autowired
    private AmbPostsaleOrdersBo ambPostsaleOrdersBo;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;
    @Autowired
    private PlatformTransactionManager creditsMasterTransactionManager;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    private AmbPostsaleOrdersService ambPostsaleOrdersService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;

    @Override
    public void canSubmitPostsaleBeforeFill(Long orderId, Long consumerId) throws Exception {
        this.canSubmitPostsale(orderId, consumerId, false, null);
    }

    @Override
    public void canSubmitPostsaleAfterFill(Long orderId, Long consumerId, Long postsaleMoney) throws Exception {
        this.canSubmitPostsale(orderId, consumerId, true, postsaleMoney);
    }

    private void canSubmitPostsale(Long orderId, Long consumerId, boolean isAfterFill, Long postsaleMoney) throws Exception {
        if (orderId == null || consumerId == null) {
            throw new Exception("\u53c2\u6570\u4e0d\u5168");
        }
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if (order == null) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(1)");
        }
        if (!"amb".equals(order.getSubOrderType())) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(2)");
        }
        if (!"after_send".equals(order.getStatus())) {
            throw new Exception("\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        if (isAfterFill && postsaleMoney > order.getConsumerPayPrice()) {
            throw new Exception("\u9000\u6b3e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u652f\u4ed8\u91d1\u989d");
        }
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        if (!order.getConsumerId().equals(consumer.getId()) || !order.getAppId().equals(consumer.getAppId())) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(3)");
        }
        AmbSubOrdersDto subOrder = this.ambSubOrdersService.findSubOrderById(order.getSubOrderId());
        if (subOrder == null) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(4)");
        }
        if (!"shipped".equals(subOrder.getShipStatus()) && !"received".equals(subOrder.getShipStatus())) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(5)");
        }
        if (subOrder.getAmbPostsaleOrdersId() == null) {
            return;
        }
        AmbPostsaleOrdersDto postsaleOrder = this.ambPostsaleOrdersService.find(subOrder.getAmbPostsaleOrdersId());
        if (postsaleOrder == null) {
            return;
        }
        if ("reject".equals(postsaleOrder.getPostsaleStatus()) || "canceled".equals(postsaleOrder.getPostsaleStatus())) {
            return;
        }
        throw new Exception("\u552e\u540e\u72b6\u6001\u4e0d\u7b26");
    }

    @Override
    public void submit(AmbPostsaleOrdersDto postsaleOrder, Long consumerId) throws Exception {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        TransactionStatus transaction = this.creditsMasterTransactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            AmbSubOrdersDto subOrder = this.ambSubOrdersService.findSubOrderById(postsaleOrder.getAmbSubOrdersId());
            if ("shipped".equals(subOrder.getShipStatus())) {
                this.ambOrderFastBo.removeOrderFastWaitReceive(subOrder.getOrdersId());
            } else if ("received".equals(subOrder.getShipStatus())) {
                this.ambOrderFastBo.removeOrderFastReceived(subOrder.getOrdersId());
            } else {
                throw new Exception("\u8ba2\u5355\u6240\u5728\u72b6\u6001\u4e0d\u5141\u8bb8\u53d1\u8d77\u552e\u540e\uff01");
            }
            this.ambPostsaleOrdersService.insert(postsaleOrder);
            this.ambOrderFastBo.createOrderFastWaitPostsale(subOrder.getOrdersId(), consumerId);
            this.ambSubOrdersService.updateAmbPostsaleOrderIdById(subOrder.getId(), postsaleOrder.getId());
            this.ambPostsaleOrderFasterBo.addOrUpdateOrderInfoFaster(subOrder.getOrdersId(), consumerId);
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            log.error("\u63d0\u4ea4\u552e\u540e\u8ba2\u5355\u5931\u8d25\uff0corderId=" + postsaleOrder.getOrdersId(), (Throwable)e);
            throw e;
        }
        finally {
            this.creditsMasterTransactionManager.commit(transaction);
        }
    }

    @Override
    public boolean isSubmittedPostsale(Long orderId, Long consumerId) throws RuntimeException {
        if (orderId == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u5168");
        }
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if (order == null) {
            throw new RuntimeException("\u8ba2\u5355\u4e0d\u5b58\u5728(1)");
        }
        if (!"amb".equals(order.getSubOrderType())) {
            throw new RuntimeException("\u8ba2\u5355\u4e0d\u5b58\u5728(2)");
        }
        AmbSubOrdersDto subOrder = this.ambSubOrdersService.findSubOrderById(order.getSubOrderId());
        if (subOrder == null) {
            throw new RuntimeException("\u8ba2\u5355\u4e0d\u5b58\u5728(4)");
        }
        if (subOrder.getAmbPostsaleOrdersId() == null) {
            return false;
        }
        AmbPostsaleOrdersDto postsaleOrder = this.ambPostsaleOrdersService.find(subOrder.getAmbPostsaleOrdersId());
        return postsaleOrder != null;
    }

    @Override
    public void cancel(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if (!"amb".equals(order.getSubOrderType())) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(2)");
        }
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        if (!order.getConsumerId().equals(consumer.getId()) || !order.getAppId().equals(consumer.getAppId())) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728(3)");
        }
        AmbSubOrdersDto subOrder = this.ambSubOrdersService.findSubOrderById(order.getSubOrderId());
        if (subOrder.getAmbPostsaleOrdersId() == null) {
            return;
        }
        AmbPostsaleOrdersDto postsaleOrder = this.ambPostsaleOrdersService.findForUpdate(subOrder.getAmbPostsaleOrdersId());
        if (postsaleOrder == null) {
            return;
        }
        if (!"wait".equals(postsaleOrder.getPostsaleStatus()) && !"agree".equals(postsaleOrder.getPostsaleStatus())) {
            return;
        }
        if ("wait".equals(postsaleOrder.getPostsaleStatus())) {
            this.ambOrderFastBo.removeOrderFastWaitPostsale(postsaleOrder.getOrdersId());
        } else if ("agree".equals(postsaleOrder.getPostsaleStatus())) {
            this.ambOrderFastBo.removeOrderFastAfterAgree(postsaleOrder.getOrdersId());
        } else {
            throw new Exception("\u552e\u540e\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        if ("shipped".equals(subOrder.getShipStatus())) {
            this.ambOrderFastBo.createOrderFastWaitReceive(postsaleOrder.getOrdersId(), consumerId);
        } else if ("received".equals(subOrder.getShipStatus())) {
            this.ambOrderFastBo.createOrderFastReceived(postsaleOrder.getOrdersId(), consumerId);
        } else {
            throw new Exception("\u5b50\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        this.ambPostsaleOrdersBo.cancel(postsaleOrder.getId());
    }

    @Override
    public boolean canSubmitPostsale4Page(Long orderId, Long consumerId) throws RuntimeException {
        if (orderId == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u5168");
        }
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if (order == null) {
            throw new RuntimeException("\u8ba2\u5355\u4e0d\u5b58\u5728(1)");
        }
        if (!"amb".equals(order.getSubOrderType())) {
            return false;
        }
        if (!"after_send".equals(order.getStatus())) {
            return false;
        }
        AmbSubOrdersDto subOrder = this.ambSubOrdersService.findSubOrderById(order.getSubOrderId());
        if (subOrder == null) {
            throw new RuntimeException("\u8ba2\u5355\u4e0d\u5b58\u5728(4)");
        }
        if (!"received".equals(subOrder.getShipStatus()) && !"shipped".equals(subOrder.getShipStatus())) {
            return false;
        }
        if (subOrder.getAmbPostsaleOrdersId() == null) {
            return true;
        }
        AmbPostsaleOrdersDto postsaleOrder = this.ambPostsaleOrdersService.find(subOrder.getAmbPostsaleOrdersId());
        if (postsaleOrder == null) {
            return true;
        }
        return "reject".equals(postsaleOrder.getPostsaleStatus()) || "canceled".equals(postsaleOrder.getPostsaleStatus());
    }
}

