/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.biz.bo.OrdersNormalUpdateManager;
import cn.com.duiba.order.center.biz.bo.OrdersStatusChangeBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPostsaleOrderFasterBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPostsaleOrdersBo;
import cn.com.duiba.order.center.biz.service.amb.AmbPaychannelOrdersService;
import cn.com.duiba.order.center.biz.service.amb.AmbPostsaleOrdersService;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ambPostsaleOrdersService")
public class AmbPostsaleOrdersBoImpl
implements AmbPostsaleOrdersBo {
    @Autowired
    private OrdersNormalUpdateManager ordersNormalUpdateManager;
    @Autowired
    private OrdersStatusChangeBo ordersStatusChangeBo;
    @Autowired
    private AmbPaychannelOrdersService ambPaychannelOrdersService;
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbPostsaleOrdersService ambPostsaleOrdersService;
    @Autowired
    private AmbPostsaleOrderFasterBo ambPostsaleOrderFasterBo;

    @Override
    public void agree(Long postsaleOrderId, String remark) {
        Date now = new Date();
        this.ambPostsaleOrdersService.doAgree(postsaleOrderId, remark, now);
        this.ambPostsaleOrderFasterBo.doAgree(postsaleOrderId);
    }

    @Override
    public void reject(Long postsaleOrderId, String remark) {
        Date now = new Date();
        this.ambPostsaleOrdersService.doReject(postsaleOrderId, remark, now, now);
        this.ambPostsaleOrderFasterBo.doReject(postsaleOrderId);
    }

    @Override
    public void cancel(Long postsaleOrderId) {
        Date now = new Date();
        this.ambPostsaleOrdersService.doCancel(postsaleOrderId, now);
        this.ambPostsaleOrderFasterBo.doCancel(postsaleOrderId);
    }

    @Override
    public void complete(Long postsaleOrderId, Long consumerId) throws Exception {
        this.ambPostsaleOrdersService.doComplete(postsaleOrderId);
        this.ambPostsaleOrderFasterBo.doRefunding(postsaleOrderId);
        this.completeOrderByPostsale(postsaleOrderId, consumerId);
    }

    private void completeOrderByPostsale(Long postsaleOrderId, Long consumerId) throws Exception {
        AmbPostsaleOrdersDto postsaleOrder = this.ambPostsaleOrdersService.find(postsaleOrderId);
        this.ordersStatusChangeBo.doAmbPayBack(postsaleOrder.getOrdersId(), consumerId);
        this.ordersNormalUpdateManager.updateConsumerPayBackPrice(postsaleOrder.getOrdersId(), consumerId, postsaleOrder.getPostsaleMoney());
        this.ambSubOrdersService.updateConsumerPayBackPriceById(postsaleOrder.getAmbSubOrdersId(), postsaleOrder.getPostsaleMoney());
        this.ambPaychannelOrdersService.updatePayBackMoneyByIdAndStatusSuccess(postsaleOrder.getAmbPaychannelOrdersId(), postsaleOrder.getPostsaleMoney());
    }

    @Override
    public void doSuccess(Long postsaleOrderId) {
        this.ambPostsaleOrdersService.doSuccess(postsaleOrderId);
        this.ambPostsaleOrderFasterBo.doSuccess(postsaleOrderId);
    }
}

