/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.order.center.biz.bo.ConsumerFootprintService;
import cn.com.duiba.order.center.biz.bo.QuantityLimitService;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.domain.dataobject.ConsumerFootprintDO;
import cn.com.duiba.service.domain.dataobject.FootprintDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.remoteservice.RemoteConsumerFootPrintService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ConsumerFootprintServiceImpl
implements ConsumerFootprintService {
    private static Logger log = LoggerFactory.getLogger(ConsumerFootprintService.class);
    @Resource
    @Qualifier(value="remoteConsumerFootPrintService")
    private RemoteConsumerFootPrintService remoteConsumerFootPrintService;
    @Autowired
    private QuantityLimitService quantityLimitService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerFootprintDO findByConsumerId(Long consumerId) {
        try {
            TimeProfile.enter("findConsumerFootprint");
            DubboResult dubboResult = this.remoteConsumerFootPrintService.findByConsumerId(consumerId);
            ConsumerFootprintDO consumerFootprintDO = (ConsumerFootprintDO)dubboResult.getResult();
            return consumerFootprintDO;
        }
        finally {
            TimeProfile.release();
        }
    }

    @Override
    public Boolean validateFootprint(ConsumerFootprintDO footprintData, ItemKey itemKey, String degree) {
        if ("virtual".equals(itemKey.getItemType())) {
            degree = null;
        }
        if (footprintData == null) {
            return true;
        }
        List footprints = footprintData.getColumnDataByType(itemKey.getItemType());
        if (footprints == null || footprints.size() < 1) {
            return true;
        }
        int tmpNum = 0;
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            ItemDO item = itemKey.getItem();
            if (degree != null && item.isDegree()) {
                String limitScope;
                String customPrice = itemKey.getAppItem() == null ? item.getCustomPrice() : itemKey.getAppItem().getCustomPrice();
                PriceDegree pd = new PriceDegree(customPrice);
                Map map = pd.getLimitByDegree(String.valueOf(degree));
                String limitCount = map == null ? null : (String)map.get("limitCount");
                String string = limitScope = map == null ? null : (String)map.get("limitScope");
                if (StringUtils.isEmpty((String)limitCount) || StringUtils.isEmpty((String)limitScope)) {
                    return true;
                }
                if (limitScope.equals("everyday")) {
                    long today = DateUtils.getTodayZeroTimeInMillis();
                    for (FootprintDO footprintDO : footprints) {
                        if (footprintDO.getItemId() == null || footprintDO.getGmtCreate() <= today || !footprintDO.getItemId().equals(itemKey.getItem().getId()) || !footprintDO.getDegree().equals(degree)) continue;
                        ++tmpNum;
                    }
                } else if (limitScope.equals("month")) {
                    long firstDay = DateUtils.getMonthFirstDayTimeInMillis();
                    long lastDay = DateUtils.getNextMonthFirstDayTimeInMillis();
                    for (FootprintDO footprintDO : footprints) {
                        if (footprintDO.getItemId() == null || footprintDO.getGmtCreate() <= firstDay || footprintDO.getGmtCreate() >= lastDay || !footprintDO.getItemId().equals(itemKey.getItem().getId()) || !footprintDO.getDegree().equals(degree)) continue;
                        ++tmpNum;
                    }
                } else if (limitScope.equals("forever")) {
                    for (FootprintDO footprintDO : footprints) {
                        if (footprintDO.getItemId() == null || !footprintDO.getItemId().equals(itemKey.getItem().getId()) || !footprintDO.getDegree().equals(degree)) continue;
                        ++tmpNum;
                    }
                }
                if (tmpNum >= Integer.valueOf(limitCount)) {
                    return false;
                }
                return true;
            }
            if (itemKey.getItem().getLimitCount() == null) {
                if (itemKey.getAppItem() == null || itemKey.getAppItem().getLimitCount() == null) {
                    return true;
                }
                if (itemKey.getAppItem().getLimitScope().equals("everyday")) {
                    long today = DateUtils.getTodayZeroTimeInMillis();
                    for (FootprintDO footprintDO : footprints) {
                        if (footprintDO.getAppItemId() == null || footprintDO.getGmtCreate() <= today || !footprintDO.getAppItemId().equals(itemKey.getAppItem().getId())) continue;
                        ++tmpNum;
                    }
                } else if (itemKey.getAppItem().getLimitScope().equals("forever")) {
                    for (FootprintDO footprintDO : footprints) {
                        if (footprintDO.getAppItemId() == null || !footprintDO.getAppItemId().equals(itemKey.getAppItem().getId())) continue;
                        ++tmpNum;
                    }
                }
                if (tmpNum >= itemKey.getAppItem().getLimitCount()) {
                    return false;
                }
                return true;
            }
            if (itemKey.getItem().getLimitScope().equals("everyday")) {
                long today = DateUtils.getTodayZeroTimeInMillis();
                for (FootprintDO footprintDO : footprints) {
                    if (footprintDO.getItemId() == null || footprintDO.getGmtCreate() <= today || !footprintDO.getItemId().equals(itemKey.getItem().getId())) continue;
                    ++tmpNum;
                }
            } else if (itemKey.getItem().getLimitScope().equals("forever")) {
                for (FootprintDO footprintDO : footprints) {
                    if (footprintDO.getItemId() == null || !footprintDO.getItemId().equals(itemKey.getItem().getId())) continue;
                    ++tmpNum;
                }
            } else if (itemKey.getItem().getLimitScope().equals("batch")) {
                for (FootprintDO footprintDO : footprints) {
                    if (footprintDO.getRelationId() == null || itemKey.getItem().getBatchId() == null || !footprintDO.getRelationId().equals(itemKey.getItem().getBatchId().toString())) continue;
                    ++tmpNum;
                }
            }
            if (tmpNum >= itemKey.getItem().getLimitCount()) {
                return false;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            if (itemKey.getAppItem().getLimitCount() == null) {
                return true;
            }
            if (itemKey.getAppItem().getLimitScope().equals("everyday")) {
                long today = DateUtils.getTodayZeroTimeInMillis();
                for (FootprintDO footprintDO : footprints) {
                    if (footprintDO.getAppItemId() == null || footprintDO.getGmtCreate() <= today || !footprintDO.getAppItemId().equals(itemKey.getAppItem().getId())) continue;
                    ++tmpNum;
                }
            } else if (itemKey.getAppItem().getLimitScope().equals("forever")) {
                for (FootprintDO footprintDO : footprints) {
                    if (footprintDO.getAppItemId() == null || !footprintDO.getAppItemId().equals(itemKey.getAppItem().getId())) continue;
                    ++tmpNum;
                }
            }
            if (tmpNum >= itemKey.getAppItem().getLimitCount()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addFootprint(Long consumerId, Long orderId, ItemKey itemKey, String degree) {
        try {
            if (!this.quantityLimitService.isLimit(itemKey).booleanValue()) {
                return;
            }
            String coulum = ConsumerFootprintDO.getColumnByType((String)itemKey.getItemType());
            ConsumerFootprintDO footprintData = null;
            DubboResult dubboResult = this.remoteConsumerFootPrintService.findByColumnAndConsumerId(consumerId, coulum);
            footprintData = !dubboResult.isSuccess() || dubboResult.getResult() == null ? new ConsumerFootprintDO(true) : (ConsumerFootprintDO)dubboResult.getResult();
            List footprints = footprintData.getColumnDataByType(itemKey.getItemType());
            if (footprints.size() >= FootprintDO.MAX_NUM) {
                int removeNum = footprints.size() - FootprintDO.MAX_NUM;
                int tempRemoveNum = 0;
                Iterator it = footprints.iterator();
                while (it.hasNext() && tempRemoveNum <= removeNum) {
                    FootprintDO fp = (FootprintDO)it.next();
                    if (!StringUtils.isEmpty((String)fp.getTag())) continue;
                    it.remove();
                    ++tempRemoveNum;
                }
            }
            FootprintDO footprint = new FootprintDO();
            footprint.setOrderId(orderId);
            footprint.setAppItemId(itemKey.getAppItem() != null ? itemKey.getAppItem().getId() : null);
            footprint.setItemId(itemKey.getItem() != null ? itemKey.getItem().getId() : null);
            footprint.setDegree(degree);
            footprint.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
            if (this.quantityLimitService.isLimit(itemKey).booleanValue()) {
                footprint.setTag(FootprintDO.TAG_LIMIT);
            }
            if ("coupon".equals(itemKey.getItemType()) && itemKey.getItem() != null && itemKey.getItem().getBatchId() != null) {
                footprint.setRelationId(itemKey.getItem().getBatchId().toString());
            }
            footprints.add(footprint);
            footprintData.setColumnByType(itemKey.getItemType(), footprints);
            footprintData.setConsumerId(consumerId);
            if (footprintData.getId() == null) {
                footprintData.setGmtCreate(new Date());
                footprintData.setGmtModified(new Date());
                this.remoteConsumerFootPrintService.insert(footprintData);
            } else {
                footprintData.setGmtModified(new Date());
                this.remoteConsumerFootPrintService.updateByConsumerId(footprintData);
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5151\u6362\u8db3\u8ff9\u5f02\u5e38: orderId=" + orderId, (Throwable)e);
        }
    }

    @Override
    public void rollbackFootprint(Long consumerId, Long orderId, ItemKey itemKey) {
        try {
            String coulum = ConsumerFootprintDO.getColumnByType((String)itemKey.getItemType());
            ConsumerFootprintDO footprintData = null;
            DubboResult dubboResult = this.remoteConsumerFootPrintService.findByColumnAndConsumerId(consumerId, coulum);
            if (!dubboResult.isSuccess() || dubboResult.getResult() == null) {
                return;
            }
            footprintData = (ConsumerFootprintDO)dubboResult.getResult();
            List footprints = footprintData.getColumnDataByType(itemKey.getItemType());
            if (footprints != null) {
                Iterator it = footprints.iterator();
                while (it.hasNext()) {
                    FootprintDO fp = (FootprintDO)it.next();
                    if (!fp.getOrderId().equals(orderId)) continue;
                    it.remove();
                    break;
                }
                footprintData.setColumnByType(itemKey.getItemType(), footprints);
                footprintData.setGmtModified(new Date());
                this.remoteConsumerFootPrintService.updateByConsumerId(footprintData);
            }
        }
        catch (Exception e) {
            log.error("\u56de\u6eda\u5151\u6362\u8db3\u8ff9\u5f02\u5e38\uff1a orderId=" + orderId, (Throwable)e);
        }
    }
}

