/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.order.center.api.dto.orders.OrderSyncMessage;
import cn.com.duiba.order.center.biz.bo.OrderSyncBo;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.mirror.OrdersMirrorSyncService;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderSyncBoImpl
implements OrderSyncBo {
    private static Logger log = LoggerFactory.getLogger(OrderSyncBoImpl.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private OrdersMirrorSyncService ordersMirrorSyncService;

    @Override
    public void sync(Long orderId, Long consumerId) {
        try {
            OrderSyncMessage msg = new OrderSyncMessage();
            msg.setOrderId(orderId);
            msg.setConsumerId(consumerId);
            String body = JSONObject.toJSONString((Object)msg);
            this.messageService.sendMsg(this.topicConstant.getTopicOrdersSync(), body);
        }
        catch (Exception e) {
            log.error("order sync error:[orderId:" + orderId + " consumerId:" + consumerId + "]", (Throwable)e);
        }
    }
}

