/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.unique_check.RemoteUniqueOrderNumCheckService;
import cn.com.duiba.order.center.biz.bo.OrdersInsertManager;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbSubOrdersBo;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.paycenter.client.PayCenterServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.dto.DuibaRemainingMoneyDto;
import cn.com.duiba.paycenter.service.DuibaRemainingMoneyService;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ordersInsertManager")
public class OrdersInsertManagerImpl
implements OrdersInsertManager {
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;
    @Autowired
    private RemoteUniqueOrderNumCheckService remoteUniqueOrderNumCheckService;
    @Autowired
    private PayCenterServiceClient payCenterServiceClient;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private DuibaRemainingMoneyService duibaRemainingMoneyService;
    @Autowired
    private AmbSubOrdersBo ambSubOrdersBo;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;

    @Override
    public OrdersDto takeOrderFree(OrdersDto order) throws Exception {
        if (order.getId() != null) {
            throw new Exception("\u521b\u5efa\u8ba2\u5355\u65f6\uff0cid\u5fc5\u987b\u4e3a\u7a7a");
        }
        this.ordersTextChangeService.insert(order);
        return order;
    }

    @Override
    public OrdersDto takeOrderInFee(OrdersDto order, ItemKey key) throws Exception {
        if (order.getId() != null) {
            throw new Exception("\u521b\u5efa\u8ba2\u5355\u65f6\uff0cid\u5fc5\u987b\u4e3a\u7a7a");
        }
        this.checkAccountMoneyByDevelopId(order, key);
        this.remoteAppService.deductBudget(key.getApp().getId(), order.getActualPrice());
        this.ordersTextChangeService.insert(order);
        return order;
    }

    private void checkAccountMoneyByDevelopId(OrdersDto order, ItemKey key) throws StatusException {
        RpcResult rpcResult = this.payCenterServiceClient.getBalance(key.getApp().getDeveloperId());
        if (!rpcResult.isOpSuccess()) {
            PayCenterLog.info("call payCenterServiceClient.getBalance final failed  throw exception");
            throw new RuntimeException("\u4ece\u652f\u4ed8\u4e2d\u5fc3\u83b7\u53d6\u91d1\u989d \u5931\u8d25 ", (Throwable)rpcResult.getRpcException());
        }
        if ((Long)rpcResult.getResult() < (long)order.getActualPrice().intValue()) {
            throw new StatusException(2);
        }
    }

    @Override
    public OrdersDto duibaTakeOrderInFee(OrdersDto order, ItemKey key) throws Exception {
        if (order.getId() != null) {
            throw new Exception("\u521b\u5efa\u8ba2\u5355\u65f6\uff0cid\u5fc5\u987b\u4e3a\u7a7a");
        }
        DuibaRemainingMoneyDto duibaM = this.duibaRemainingMoneyService.findRecord();
        Long money = duibaM.getMoney();
        if (money < (long)order.getDuibaActualPrice().intValue()) {
            throw new StatusException(2);
        }
        this.ordersTextChangeService.insert(order);
        return order;
    }

    @Override
    public OrdersDto ambTakeOrderInFee(OrdersDto order, ItemKey key) throws Exception {
        if (order.getId() != null) {
            throw new Exception("\u521b\u5efa\u8ba2\u5355\u65f6\uff0cid\u5fc5\u987b\u4e3a\u7a7a");
        }
        this.ordersTextChangeService.insert(order);
        AmbSubOrdersDto sub = this.ambSubOrdersBo.createAmbSubOrder(order, key);
        this.ordersTextChangeService.updateSubOrderIdById(order.getId(), order.getConsumerId(), sub.getId());
        int ret = this.ambOrderFastBo.createOrderFastMaxTime(order.getId(), order.getConsumerId());
        if (ret == 0) {
            throw new Exception("\u52a0\u901f  \u5b9a\u5355\u5df2\u7ecf\u5b58\u5728");
        }
        return order;
    }
}

