/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.order.center.api.dto.phone_bill.PhoneAttributionDto;
import cn.com.duiba.order.center.biz.bo.PhoneAttributionBo;
import cn.com.duiba.order.center.biz.service.phone_bill.PhoneAttributionService;
import cn.com.duiba.order.center.biz.service.phone_bill.impl.PhoneAttributionServiceImpl;
import java.io.StringReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xml.sax.InputSource;

@Service
public class PhoneAttributionBoImpl
implements PhoneAttributionBo {
    private static Logger log = LoggerFactory.getLogger(PhoneAttributionServiceImpl.class);
    final String phoneQuery = "http://life.tenpay.com/cgi-bin/mobile/MobileQueryAttribution.cgi?chgmobile=";
    @Autowired
    PhoneAttributionService phoneAttributionService;

    @Override
    public PhoneAttributionDto findByPhone(String phone) throws Exception {
        PhoneAttributionDto attr = null;
        try {
            String phone7 = phone.substring(0, 7);
            attr = this.phoneAttributionService.findByPhone(phone7);
            if (attr == null) {
                attr = this.findByNetwork(phone);
                PhoneAttributionDto attr4insert = new PhoneAttributionDto(true);
                attr4insert.setPhone(phone7);
                attr4insert.setSupplier(attr.getSupplier());
                attr4insert.setProvince(attr.getProvince());
                attr4insert.setCity(attr.getCity());
                this.phoneAttributionService.insert(attr4insert);
            }
        }
        catch (Exception e) {
            log.error("PhoneAttributionService findByPhone :", (Throwable)e);
            throw new Exception("\u83b7\u53d6\u53f7\u7801\u5f52\u5c5e\u5730\u5f02\u5e38\uff1a", e);
        }
        return attr;
    }

    @Override
    public PhoneAttributionDto findByNetwork(String phone) throws Exception {
        PhoneAttributionDto attr = null;
        try {
            String url = "http://life.tenpay.com/cgi-bin/mobile/MobileQueryAttribution.cgi?chgmobile=" + phone;
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(url);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"gb2312");
            StringReader xmlReader = new StringReader(body);
            InputSource xmlSource = new InputSource(xmlReader);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(xmlSource);
            Element root = doc.getRootElement();
            if ("ok".equals(root.getChildText("retmsg").toLowerCase())) {
                String province = root.getChildText("province");
                String city = root.getChildText("city");
                String supplier = root.getChildText("supplier");
                attr = new PhoneAttributionDto();
                attr.setPhone(phone.substring(0, 7));
                attr.setSupplier(supplier);
                attr.setProvince(province);
                attr.setCity(city);
            }
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u53f7\u7801\u5f52\u5c5e\u5730\u5f02\u5e38\uff1a", e);
        }
        return attr;
    }
}

