/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.IntegerTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TodayCountService {
    private static Logger log = LoggerFactory.getLogger(TodayCountService.class);
    @Autowired
    private MemcachedClient memcachedClient;
    private final String EXPECT_NAMESPACE = "expectnamespace";

    public ExpectVO findTodayExpect(Long appId) {
        ExpectVO expect = new ExpectVO();
        try {
            String orderCountKey = "expectnamespace" + appId + "orderCount";
            Integer orderCount = (Integer)this.memcachedClient.get(orderCountKey);
            expect.setOrderCount(orderCount == null ? 0 : orderCount);
            String creditsKey = "expectnamespace" + appId + "credits";
            Integer credits = (Integer)this.memcachedClient.get(creditsKey);
            expect.setCredits(credits == null ? 0 : credits);
            String actualPriceKey = "expectnamespace" + appId + "actualPrice";
            Integer actualPrice = (Integer)this.memcachedClient.get(actualPriceKey);
            expect.setActualPrice(actualPrice == null ? 0 : actualPrice);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4eca\u65e5\u9884\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        return expect;
    }

    public void addExpectByOrders(OrdersDto ordersDto) {
        try {
            String creditsKey;
            String orderCountKey = "expectnamespace" + ordersDto.getAppId() + "orderCount";
            if (this.setByCas(orderCountKey, 1, 1) == 2) {
                this.memcachedClient.set(orderCountKey, DateUtils.getToTomorrowSeconds(), (Object)1);
            }
            if (ordersDto.getCredits() != null && ordersDto.getCredits() > 0L && this.setByCas(creditsKey = "expectnamespace" + ordersDto.getAppId() + "credits", ordersDto.getCredits().intValue(), 1) == 2) {
                this.memcachedClient.set(creditsKey, DateUtils.getToTomorrowSeconds(), (Object)ordersDto.getCredits().intValue());
            }
            if (ordersDto.getActualPrice() != null && ordersDto.getActualPrice() > 0) {
                int actualPrice = ordersDto.getActualPrice();
                String actualPriceKey = "expectnamespace" + ordersDto.getAppId() + "actualPrice";
                if (this.setByCas(actualPriceKey, actualPrice, 1) == 2) {
                    this.memcachedClient.set(actualPriceKey, DateUtils.getToTomorrowSeconds(), (Object)actualPrice);
                }
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u9884\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public void addExpectByCredits(Long appId, Long credits) {
        try {
            String creditsKey;
            if (credits > 0L && this.setByCas(creditsKey = "expectnamespace" + appId + "credits", credits.intValue(), 1) == 2) {
                this.memcachedClient.set(creditsKey, DateUtils.getToTomorrowSeconds(), (Object)credits.intValue());
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u79ef\u5206\u5f02\u5e38", (Throwable)e);
        }
    }

    public void rollbackExpectByCredits(Long appId, Long credits) {
        if (credits > 0L) {
            try {
                String creditsKey = "expectnamespace" + appId + "credits";
                this.setByCas(creditsKey, credits.intValue(), -1);
            }
            catch (Exception e) {
                log.error("\u56de\u6eda\u79ef\u5206\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void addMoney(OrdersDto ordersDto) {
        if (ordersDto.getActualPrice() != null && ordersDto.getActualPrice() > 0) {
            int actualPrice = ordersDto.getActualPrice();
            String actualPriceKey = "expectnamespace" + ordersDto.getAppId() + "actualPrice";
            if (this.setByCas(actualPriceKey, actualPrice, 1) == 2) {
                this.memcachedClient.set(actualPriceKey, DateUtils.getToTomorrowSeconds(), (Object)actualPrice);
            }
        }
    }

    public void rollbackMoney(OrdersDto ordersDto) {
        if (ordersDto.getActualPrice() != null && ordersDto.getActualPrice() > 0 && DateUtils.getDayNumber((Date)new Date()) == DateUtils.getDayNumber((Date)ordersDto.getGmtCreate())) {
            int actualPrice = ordersDto.getActualPrice();
            String actualPriceKey = "expectnamespace" + ordersDto.getAppId() + "actualPrice";
            this.setByCas(actualPriceKey, actualPrice, -1);
        }
    }

    public void rollbackExpectByOrders(OrdersDto ordersDto) {
        try {
            if (DateUtils.getDayNumber((Date)new Date()) == DateUtils.getDayNumber((Date)ordersDto.getGmtCreate())) {
                String orderCountKey = "expectnamespace" + ordersDto.getAppId() + "orderCount";
                this.setByCas(orderCountKey, 1, -1);
                if (ordersDto.getCredits() != null && ordersDto.getCredits() > 0L) {
                    String creditsKey = "expectnamespace" + ordersDto.getAppId() + "credits";
                    this.setByCas(creditsKey, ordersDto.getCredits().intValue(), -1);
                }
                if (ordersDto.getActualPrice() != null && ordersDto.getActualPrice() > 0) {
                    int actualPrice = ordersDto.getActualPrice();
                    String actualPriceKey = "expectnamespace" + ordersDto.getAppId() + "actualPrice";
                    this.setByCas(actualPriceKey, actualPrice, -1);
                }
            }
        }
        catch (Exception e) {
            log.error("\u56de\u6eda\u9884\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    private Integer setByCas(String key, int value, int type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    nextValue += value;
                } else if (type < 0) {
                    nextValue = nextValue >= value ? (nextValue -= value) : 0;
                } else {
                    loop = false;
                    result = 4;
                    break;
                }
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtils.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new IntegerTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
            log.error("\u66f4\u65b0\u7f13\u5b58\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    public class ExpectVO {
        private Integer orderCount = 0;
        private Integer credits = 0;
        private Integer actualPrice = 0;

        public Integer getOrderCount() {
            return this.orderCount;
        }

        public void setOrderCount(Integer orderCount) {
            this.orderCount = orderCount;
        }

        public Integer getCredits() {
            return this.credits;
        }

        public void setCredits(Integer credits) {
            this.credits = credits;
        }

        public Integer getActualPrice() {
            return this.actualPrice;
        }

        public void setActualPrice(Integer actualPrice) {
            this.actualPrice = actualPrice;
        }
    }
}

