/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.OrdersNormalUpdateManager;
import cn.com.duiba.order.center.biz.bo.ordercreate.HuichangAlipayCodeOrderCreatorBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierOrdersService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HuichangAlipayCodeOrderCreatorBoImpl
extends OrderCreateBaseBo
implements HuichangAlipayCodeOrderCreatorBo {
    private static Logger log = LoggerFactory.getLogger(HuichangAlipayCodeOrderCreatorBoImpl.class);
    @Resource
    private RemotePreStockService remotePreStockService;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Autowired
    private OrdersNormalUpdateManager ordersNormalUpdateManager;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public OrdersDto createHuichangAlipayCodeOrder(DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, Integer actualPrice, Integer price, Integer quantity, String phone, String chargeMode, String developerBizId, SupplierProductDto sp) throws Exception {
        OrdersDto order = new OrdersDto(true);
        order.setIp(params.getIp());
        order.setChargeMode(chargeMode);
        order.setDeveloperBizId(developerBizId);
        order.setConsumerId(consumer.getId());
        order.setAppId(consumer.getAppId());
        order.setDeveloperId(key.getApp().getDeveloperId());
        order.setFacePrice(price);
        order.setBizParams(phone);
        order.setActualPrice(actualPrice);
        order.setItemId(key.getItem().getId());
        if (key.getAppItem() != null) {
            order.setAppItemId(key.getAppItem().getId());
        }
        order.setQuantity(quantity);
        order.setStatus("create");
        order.setType("alipaycode");
        if ("api".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else {
            Long credits = this.remotePreStockService.calculateCreditsByItemKeyAndDegree(key, quantity.toString());
            order.setCredits(credits);
            if (this.isOverThreshold(order, key.getApp())) {
                order.setAuditStatus("wait");
            }
        }
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
        } else {
            order.setDuibaPayStatus("none");
        }
        if (order.getConsumerPayPrice() > 0L) {
            order.setSubOrderType("amb");
            order.setConsumerPayStatus("wait_pay");
            throw new Exception("\u975e\u52a0\u94b1\u8d2d\u5546\u54c1");
        }
        order.setConsumerPayStatus("none");
        order.setBrief("\u624b\u673a\u53f7\uff1a" + phone + " \u652f\u4ed8\u5b9d\u5145\u503c\u7801\u5145\u503c\uff1a" + price / 100 + "\u5143");
        try {
            order = this.takeOrderIntimes(order, key, 3);
        }
        catch (Exception e1) {
            log.error("", (Throwable)e1);
        }
        Long appId = null;
        Long appItemId = null;
        Long itemId = null;
        Object supplierProductId = null;
        if (key.getApp() != null) {
            appId = key.getApp().getId();
        }
        if (key.getAppItem() != null) {
            appItemId = key.getAppItem().getId();
        }
        if (key.getItem() != null) {
            itemId = key.getItem().getId();
        }
        OrderCreateContext orderCreateContext = new OrderCreateContext(params, actualPrice, itemId, appItemId, appId, consumer.getId(), order.getId(), chargeMode, sp.getId());
        this.messageService.sendMsg(this.topicConstant.getHuichangAlipayCodeOrderCreate(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }

    @Override
    public void asynCreate(OrdersDto order, DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, String chargeMode, SupplierProductDto sp) throws Exception {
        try {
            try {
                this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, params));
            }
            catch (Exception e) {
                log.error("className: " + this.getClass().getName() + "   method: innerCreate", (Throwable)e);
            }
            if ("mall".equals(chargeMode)) {
                ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                cer.setConsumerId(consumer.getId());
                cer.setType(Integer.valueOf(1));
                cer.setOrderId(order.getId());
                this.remoteConsumerExchangeRecordService.insert(cer);
            }
            SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
            supplierOrder.setOrderId(order.getId());
            supplierOrder.setStatus("create");
            supplierOrder.setDuibaOrderNum(order.getOrderNum());
            supplierOrder.setSupplierProductId(sp.getId());
            this.supplierOrdersService.insert(supplierOrder);
            order.setSupplierOrderId(supplierOrder.getId());
            OrdersDto order4u = new OrdersDto(order.getId());
            order4u.setSupplierOrderId(order.getSupplierOrderId());
            this.ordersNormalUpdateManager.updateSupplierOrderId(order4u.getId(), order.getConsumerId(), order4u.getSupplierOrderId());
            if (order.getCredits() > 0L) {
                this.consumeCreditsLocal(order.getCredits(), consumer.getId());
            }
            OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
            DuibaPluginEventsDispatcher.get().triggerAfterOrderCreate(order, params, context);
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), consumer.getId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }
}

