/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.goods.center.api.remoteservice.front.RemotePCGGoodsService;
import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.PcgCouponOrderCreateBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PcgCouponOrderCreateBoImpl
extends OrderCreateBaseBo
implements PcgCouponOrderCreateBo {
    private static Logger log = LoggerFactory.getLogger(PcgCouponOrderCreateBoImpl.class);
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemotePCGGoodsService remotePCGGoodsService;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private OrderReadManagerBo orderReadManager;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public OrdersDto createOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param) throws Exception {
        OrdersDto order = new OrdersDto(true);
        order.setIp(param.getIp());
        order.setChargeMode("mall");
        order.setOrderNum(param.getOrderNum());
        order.setConsumerId(param.getConsumerId());
        order.setAppId(param.getAppId());
        AppDO app = this.remoteAppService.find(param.getAppId());
        order.setDeveloperId(app.getDeveloperId());
        order.setCouponId(param.getCouponId());
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("coupon");
        order.setActualPrice(Integer.valueOf(0));
        order.setPayStatus("none");
        order.setDuibaActualPrice(Integer.valueOf(0));
        order.setDuibaPayStatus("none");
        order.setConsumerPayPrice(Long.valueOf(0L));
        order.setConsumerPayStatus("none");
        order.setRelationType(Integer.valueOf(0));
        order.setRelationId(null);
        if (param.getCredits() <= 0L) {
            throw new Exception("\u79ef\u5206\u5fc5\u987b\u5927\u4e8e0");
        }
        order.setCredits(param.getCredits());
        order.setAuditStatus(OrdersDto.AuditStatusNotNeed);
        order.setItemId(param.getPcgId());
        order.setBrief(param.getBrief());
        order.setFacePrice(param.getFacePrice());
        order.setTypeInt(Integer.valueOf(GoodsTypeEnum.PLATFORM.getGtype()));
        try {
            TimeProfile.enter("takeOrderIntimes");
            this.takePcgOrder(order);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TimeProfile.release();
        }
        DuibaEvent.RequestParams rp = new DuibaEvent.RequestParams();
        rp.setUserAgent(param.getUserAgent());
        rp.setIp(param.getIp());
        rp.setConsumerId(param.getConsumerId());
        rp.setCookies(param.getCookies());
        OrderCreateContext orderCreateContext = new OrderCreateContext(rp, null, null, null, null, null, order.getId(), null, null);
        orderCreateContext.addParam("overDue", (Object)param.getOverDue());
        this.messageService.sendMsg(this.topicConstant.getPcgCouponOrderCreate(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }

    @Override
    public void asynCreate(OrdersDto order, DuibaEvent.RequestParams rp, Date overDue) throws Exception {
        try {
            try {
                this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, rp));
            }
            catch (Exception e) {
                log.error("className: " + this.getClass().getName() + "   method: innerCreate2", (Throwable)e);
            }
            try {
                if ("mall".equals(order.getChargeMode())) {
                    ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                    cer.setConsumerId(order.getConsumerId());
                    cer.setType(Integer.valueOf(1));
                    cer.setOrderId(order.getId());
                    if (overDue != null) {
                        SimpleDateFormat day = new SimpleDateFormat("yyyy-MM-dd");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String over = day.format(overDue) + " 23:59:59";
                        cer.setOverDue(sdf.parse(over));
                    }
                    this.remoteConsumerExchangeRecordService.insert(cer);
                }
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u5151\u6362\u8bb0\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)e);
            }
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), order.getConsumerId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }
}

