/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.OrdersNormalUpdateManager;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.QBOrderCreateBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QBOrderCreateBoImpl
extends OrderCreateBaseBo
implements QBOrderCreateBo {
    private static Logger log = LoggerFactory.getLogger(QBOrderCreateBoImpl.class);
    @Resource
    private RemotePreStockService remotePreStockService;
    @Autowired
    private OrdersNormalUpdateManager ordersNormalUpdateManager;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public OrdersDto innerCreateOrder(DuibaEvent.RequestParams params, Integer actualPrice, ItemKey key, ConsumerDO consumer, Boolean isDuiba, Integer quantity, String qq, String chargeMode, String developerBizId, Long relationId, Integer relationType, SupplierProductDto sp) throws Exception {
        OrdersDto order = new OrdersDto(true);
        order.setIp(params.getIp());
        order.setConsumerId(consumer.getId());
        order.setAppId(consumer.getAppId());
        order.setDeveloperId(key.getApp().getDeveloperId());
        order.setFacePrice(Integer.valueOf(quantity * 100));
        order.setActualPrice(actualPrice);
        if (isDuiba.booleanValue()) {
            order.setActualPrice(Integer.valueOf(0));
            order.setDuibaActualPrice(actualPrice);
        }
        order.setQuantity(quantity);
        order.setStatus("create");
        order.setType("qb");
        order.setBizParams(qq);
        order.setItemId(key.getItem().getId());
        if (key.getAppItem() != null) {
            order.setAppItemId(key.getAppItem().getId());
        }
        order.setBrief("QQ\u53f7\uff1a" + qq + " \u5145\u503c" + quantity + " Q\u5e01");
        order.setChargeMode(chargeMode);
        if ("turntable".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
        } else if ("singlelottery".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("mall".equals(order.getChargeMode())) {
            order.setCredits(this.remotePreStockService.calculateCreditsByItemKeyAndDegree(key, quantity.toString()));
            if (this.isOverThreshold(order, key.getApp())) {
                order.setAuditStatus("wait");
            }
        } else if ("hdtool".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        } else if ("game".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        } else if ("question".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        } else if ("quizz".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        } else if ("ngame".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        } else if ("guess".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        } else if ("activity".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
        }
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
        } else {
            order.setDuibaPayStatus("none");
        }
        if (order.getConsumerPayPrice() > 0L) {
            order.setSubOrderType("amb");
            order.setConsumerPayStatus("wait_pay");
            throw new Exception("\u975e\u52a0\u94b1\u8d2d\u5546\u54c1");
        }
        order.setConsumerPayStatus("none");
        order.setDeveloperBizId(developerBizId);
        order.setRelationType(relationType);
        order.setRelationId(relationId);
        order = this.takeOrderIntimes(order, key, 3);
        Long appId = null;
        Long appItemId = null;
        Long itemId = null;
        Object supplierProductId = null;
        if (key.getApp() != null) {
            appId = key.getApp().getId();
        }
        if (key.getAppItem() != null) {
            appItemId = key.getAppItem().getId();
        }
        if (key.getItem() != null) {
            itemId = key.getItem().getId();
        }
        OrderCreateContext orderCreateContext = new OrderCreateContext(params, actualPrice, itemId, appItemId, appId, consumer.getId(), order.getId(), chargeMode, sp.getId());
        this.messageService.sendMsg(this.topicConstant.getQbOrderCreate(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }

    @Override
    public void asynCreate(DuibaEvent.RequestParams params, OrdersDto order, ConsumerDO consumer, String chargeMode, ItemKey key, SupplierProductDto sp) throws Exception {
        try {
            OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
            try {
                DuibaPluginEventsDispatcher.get().triggerBeforeOrderCreate(key, consumer, chargeMode, params, context);
            }
            catch (Exception e) {
                DuibaPluginEventsDispatcher.get().triggerOnOrderCreateException(key, consumer, chargeMode, params, e, context);
                throw e;
            }
            try {
                this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, params));
            }
            catch (Exception e) {
                log.error("className: " + this.getClass().getName() + "   method: innerCreateOrder", (Throwable)e);
            }
            if ("mall".equals(chargeMode)) {
                ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                cer.setConsumerId(consumer.getId());
                cer.setType(Integer.valueOf(1));
                cer.setOrderId(order.getId());
                this.remoteConsumerExchangeRecordService.insert(cer);
            }
            SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
            supplierOrder.setOrderId(order.getId());
            supplierOrder.setStatus("create");
            supplierOrder.setDuibaOrderNum(order.getOrderNum());
            supplierOrder.setSupplierProductId(sp.getId());
            supplierOrder.setBizParams(order.getBizParams());
            this.remoteSupplierOrdersService.insert(supplierOrder);
            order.setSupplierOrderId(supplierOrder.getId());
            OrdersDto o4u = new OrdersDto(order.getId());
            o4u.setSupplierOrderId(order.getSupplierOrderId());
            this.ordersNormalUpdateManager.updateSupplierOrderId(o4u.getId(), order.getConsumerId(), o4u.getSupplierOrderId());
            if (order.getCredits() > 0L) {
                this.consumeCreditsLocal(order.getCredits(), consumer.getId());
            }
            DuibaPluginEventsDispatcher.get().triggerAfterOrderCreate(order, params, context);
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), consumer.getId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }
}

