/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.consumer.ordercreate;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.bo.ordercreate.CouponOrderCreateBo;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.consumer.ordercreate.OrderCreateContextTool;
import cn.com.duiba.order.center.biz.consumer.ordercreate.SupperConsumer;
import cn.com.duiba.order.center.biz.tool.KafkaClient;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponOrderCreateConsumer
extends OrderCreateContextTool
implements SupperConsumer {
    private static Logger log = LoggerFactory.getLogger(CouponOrderCreateConsumer.class);
    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private CouponOrderCreateBo couponOrderCreateBo;
    private static int pool = 2;
    private ExecutorService executorService;

    @Override
    public synchronized void start() {
        if (this.executorService != null) {
            return;
        }
        this.executorService = Executors.newFixedThreadPool(pool, new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-phonebill-Consumer-" + this.i++);
            }
        });
        for (int i = 0; i < pool; ++i) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Properties props = new Properties();
                        props.put("bootstrap.servers", CouponOrderCreateConsumer.this.kafkaClient.getBootstrapServers());
                        props.put("group.id", "trade-center");
                        props.put("enable.auto.commit", "false");
                        props.put("session.timeout.ms", "30000");
                        props.put("auto.offset.reset", "earliest");
                        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        KafkaConsumer consumer = new KafkaConsumer(props);
                        consumer.subscribe(Arrays.asList(CouponOrderCreateConsumer.this.topicConstant.getCouponOrderCreate()));
                        while (!Thread.currentThread().isInterrupted()) {
                            ConsumerRecords records = consumer.poll(100L);
                            for (TopicPartition pt : records.partitions()) {
                                for (ConsumerRecord record : records.records(pt)) {
                                    OrderCreateContext context = null;
                                    try {
                                        context = (OrderCreateContext)JSONObject.parseObject((String)((String)record.value()), OrderCreateContext.class);
                                        SupplierProductDto sp = null;
                                        ConsumerDO consumerDO = CouponOrderCreateConsumer.this.remoteConsumerService.find(context.getConsumerId());
                                        OrdersDto ordersDto = CouponOrderCreateConsumer.this.ordersSimpleService.find(context.getOrderId(), context.getConsumerId());
                                        if (context.getSupplierProductId() != null && context.getSupplierProductId() > 0L) {
                                            sp = CouponOrderCreateConsumer.this.remotesupplierProductsService.find(context.getSupplierProductId());
                                        }
                                        ItemKey key = CouponOrderCreateConsumer.this.remoteItemKeyService.getItemKey(context.getItemId(), context.getAppItemId(), context.getAppId());
                                        Long couponId = null;
                                        if (context.getParamsMap().containsKey("couponId")) {
                                            couponId = (Long)context.getParamsMap().get("couponId");
                                        }
                                        CouponOrderCreateConsumer.this.couponOrderCreateBo.asynCreate(context.getParams(), ordersDto, consumerDO, context.getChargeMode(), key, couponId);
                                    }
                                    catch (Exception e) {
                                        log.error("CouponOrderCallback consumer error:", (Throwable)e);
                                    }
                                    finally {
                                        long lastOffset = record.offset();
                                        System.out.println(context);
                                        consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1L)));
                                    }
                                }
                            }
                        }
                        consumer.close();
                    }
                    catch (Exception e) {
                        log.error("error:", (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }
}

