/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.consumer.supplier;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.consumer.ordercreate.SupperConsumer;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.VirtualSupplier2;
import cn.com.duiba.order.center.biz.tool.KafkaClient;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualCallbackConsumer
implements SupperConsumer {
    private static Logger log = LoggerFactory.getLogger(VirtualCallbackConsumer.class);
    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private VirtualSupplier2 virtualSupplier2;
    private static int pool = 5;
    private ExecutorService executorService;

    @Override
    public void start() {
        if (this.executorService != null) {
            return;
        }
        this.executorService = Executors.newFixedThreadPool(pool, new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-Virtual-Consumer-" + this.i++);
            }
        });
        for (int i = 0; i < pool; ++i) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Properties props = new Properties();
                        props.put("bootstrap.servers", VirtualCallbackConsumer.this.kafkaClient.getBootstrapServers());
                        props.put("group.id", "default");
                        props.put("enable.auto.commit", "false");
                        props.put("session.timeout.ms", "30000");
                        props.put("auto.offset.reset", "earliest");
                        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        KafkaConsumer consumer = new KafkaConsumer(props);
                        consumer.subscribe(Arrays.asList(VirtualCallbackConsumer.this.topicConstant.getVirtualCallback()));
                        while (!Thread.currentThread().isInterrupted()) {
                            ConsumerRecords records = consumer.poll(100L);
                            for (TopicPartition pt : records.partitions()) {
                                for (ConsumerRecord record : records.records(pt)) {
                                    try {
                                        SupplierResponse response = (SupplierResponse)JSONObject.parseObject((String)((String)record.value()), SupplierResponse.class);
                                        log.error("VirtualCallback consumer:" + response.getOrderId());
                                        VirtualCallbackConsumer.this.virtualSupplier2.supplierCallback(response);
                                    }
                                    catch (Exception e) {
                                        log.error("VirtualCallback consumer error:", (Throwable)e);
                                    }
                                    finally {
                                        long lastOffset = record.offset();
                                        consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1L)));
                                    }
                                }
                            }
                        }
                        consumer.close();
                    }
                    catch (Exception e) {
                        log.error("error:", (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }
}

