/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener;

import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerPCGOrderRecordService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.front.RemotePCGGoodsService;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class PcgCouponOrderFailListener
implements InitializingBean {
    @Autowired
    private RemoteConsumerPCGOrderRecordService remoteConsumerPCGOrderRecordService;
    @Autowired
    private RemotePCGGoodsService remotePCGGoodsService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderSuccess(OrdersDto order) {
                if (order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype()) {
                    PcgCouponOrderFailListener.this.remoteConsumerPCGOrderRecordService.addLastTimeOrderRecord(GoodsTypeEnum.PLATFORM, order.getItemId(), order.getConsumerId(), order.getId());
                }
            }

            @Override
            public void onOrderFail(OrdersDto order) {
                if (order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype()) {
                    PcgCouponOrderFailListener.this.remotePCGGoodsService.rollbackPCGCoupon(order.getItemId().longValue(), order.getConsumerId().longValue(), order.getCouponId().longValue(), order.getOrderNum());
                }
            }

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }
        });
    }
}

