/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.consumer_success;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.order.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.ConsumerCreditsSuccessEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.wolf.utils.DateUtils;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumeCreditsSuccessAlarmListener
implements ConsumerCreditsSuccessEvent.ConsumeCreditsSuccessListener,
InitializingBean {
    @Autowired
    private MemcachedClient memcachedClient;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registConsumeCreditsSuccessEvent(this);
    }

    private String getKey(Long appId) {
        return "119-" + appId;
    }

    private synchronized void plus(Long appId) {
        Integer value = (Integer)this.memcachedClient.get(this.getKey(appId));
        if (value == null) {
            value = 1;
            this.memcachedClient.set(this.getKey(appId), DateUtils.getToTomorrowSeconds(), (Object)value);
        } else {
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
            this.memcachedClient.set(this.getKey(appId), DateUtils.getToTomorrowSeconds(), (Object)value);
        }
    }

    private boolean haveConsumeCredits(OrdersDto order) {
        if ("api".equals(order.getChargeMode())) {
            return false;
        }
        if ("turntable".equals(order.getChargeMode())) {
            return false;
        }
        if ("manuallottery".equals(order.getChargeMode())) {
            return false;
        }
        if ("singlelottery".equals(order.getChargeMode())) {
            return false;
        }
        if ("hdtool".equals(order.getChargeMode())) {
            return false;
        }
        if ("game".equals(order.getChargeMode())) {
            return false;
        }
        if ("question".equals(order.getChargeMode())) {
            return false;
        }
        if ("quizz".equals(order.getChargeMode())) {
            return false;
        }
        if ("ngame".equals(order.getChargeMode())) {
            return false;
        }
        if ("guess".equals(order.getChargeMode())) {
            return false;
        }
        if ("activity".equals(order.getChargeMode())) {
            return false;
        }
        return order.getCredits() > 0L;
    }

    @Override
    public void onConsumeOrderSuccess(OrdersDto order) {
        if (this.haveConsumeCredits(order)) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeTurntableSuccess(TurntableOrderDO order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeSingleLotterySuccess(SingleLotteryOrderDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeManualLotterySuccess(ManualLotteryOrderDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeHdtoolLotterySuccess(HdtoolOrdersDto order) {
        if (order.getSourceOrderId() == null && order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeGameLotterySuccess(GameOrdersDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeQuestionLotterySuccess(DuibaQuestionAnswerOrdersDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeQuizzLotterySuccess(QuizzOrdersDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeNgameLotterySuccess(NgameOrdersDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }

    @Override
    public void onConsumeGuessLotterySuccess(GuessOrdersDto order) {
        if (order.getCredits() > 0L) {
            this.plus(order.getAppId());
        }
    }
}

