/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.plugin.stock;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.orders.consumer.RemoteOrdersTextChangeService;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteCouponFlowService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CouponStockPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(CouponStockPlugin.class);
    @Autowired
    private RemoteCouponFlowService remoteCouponFlowService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteOrdersTextChangeService ordersNormalUpdateManager;
    @Autowired
    private RemotePreStockService remotePreStockService;
    private OrdersEvent.OrdersEventListener ordersEventListener = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
        }

        @Override
        public void onOrderSuccess(OrdersDto order) {
        }

        @Override
        public void onOrderFail(OrdersDto order) {
            Long couponId;
            ItemKey itemKey = CouponStockPlugin.this.remoteItemKeyService.getItemKey(order.getItemId(), order.getAppItemId(), order.getAppId());
            if (this.chargeModeCheck(order.getChargeMode()) && itemKey.getItemType().equals("coupon") && (couponId = order.getCouponId()) != null) {
                CouponStockPlugin.this.ordersNormalUpdateManager.releaseCouponByOrderId(order.getId(), order.getConsumerId());
                CouponStockPlugin.this.remotePreStockService.increaseRemaining(itemKey, couponId);
            }
        }

        @Override
        public void onOrderAuditPass(OrdersDto order) {
        }

        @Override
        public void onOrderAuditReject(OrdersDto order) {
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }

        private boolean chargeModeCheck(String chargeMode) {
            if ("hdtool".equals(chargeMode)) {
                return false;
            }
            if ("singlelottery".equals(chargeMode)) {
                return false;
            }
            if ("turntable".equals(chargeMode)) {
                return false;
            }
            if ("manuallottery".equals(chargeMode)) {
                return false;
            }
            if ("game".equals(chargeMode)) {
                return false;
            }
            if ("question".equals(chargeMode)) {
                return false;
            }
            if ("quizz".equals(chargeMode)) {
                return false;
            }
            if ("ngame".equals(chargeMode)) {
                return false;
            }
            if ("guess".equals(chargeMode)) {
                return false;
            }
            return !"activity".equals(chargeMode);
        }
    };
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){
        private static final String COUPON_STOCK = "__coupon_stock_consume";

        @Override
        public void beforeOrderCreate(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) throws Exception {
            if (this.chargeModeCheck(chargeMode) && "coupon".equals(itemKey.getItemType())) {
                try {
                    CouponDO coupon = CouponStockPlugin.this.remoteCouponFlowService.getOneCoupon(itemKey);
                    if (coupon == null) {
                        throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
                    }
                    context.setAttribute(COUPON_STOCK, true);
                    context.setAttribute("couponId", coupon.getId());
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: getOneCoupon,\u4f18\u60e0\u5238\u51cf\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void onOrderCreateException(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, Exception exception, OrdersPlugin.OrdersPluginContext context) {
            if (this.chargeModeCheck(chargeMode) && "coupon".equals(itemKey.getItemType())) {
                try {
                    Boolean hasadd = (Boolean)context.getAttribute(COUPON_STOCK);
                    Object couponId = context.getAttribute("couponId");
                    if (hasadd != null && hasadd.booleanValue() && couponId != null) {
                        CouponStockPlugin.this.remoteCouponFlowService.returnOneCoupon(((Long)couponId).longValue());
                    }
                    context.remove(COUPON_STOCK);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: returnOneCoupon,\u4f18\u60e0\u5238\u8fd4\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }

        private boolean chargeModeCheck(String chargeMode) {
            if ("hdtool".equals(chargeMode)) {
                return false;
            }
            if ("singlelottery".equals(chargeMode)) {
                return false;
            }
            if ("turntable".equals(chargeMode)) {
                return false;
            }
            if ("manuallottery".equals(chargeMode)) {
                return false;
            }
            if ("game".equals(chargeMode)) {
                return false;
            }
            if ("question".equals(chargeMode)) {
                return false;
            }
            if ("quizz".equals(chargeMode)) {
                return false;
            }
            if ("seckill".equals(chargeMode)) {
                return false;
            }
            if ("ngame".equals(chargeMode)) {
                return false;
            }
            if ("guess".equals(chargeMode)) {
                return false;
            }
            return !"activity".equals(chargeMode);
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.ordersEventListener);
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }
}

