/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.plugin.stock;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.PreStockPointDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreStockLimitPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(PreStockLimitPlugin.class);
    @Autowired
    private RemotePreStockService remotePreStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    private OrdersEvent.OrdersEventListener ordersEventListener = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
        }

        @Override
        public void onOrderSuccess(OrdersDto order) {
        }

        @Override
        public void onOrderFail(OrdersDto order) {
            ItemKey itemKey = PreStockLimitPlugin.this.remoteItemKeyService.getItemKey(order.getItemId(), order.getAppItemId(), order.getAppId());
            if (this.preStockCheck(itemKey, order.getChargeMode())) {
                try {
                    PreStockLimitPlugin.this.remotePreStockService.paybackStock(order.getOrderNum());
                }
                catch (Exception e) {
                    log.error("\u8fd4\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
                }
            }
        }

        @Override
        public void onOrderAuditPass(OrdersDto order) {
        }

        @Override
        public void onOrderAuditReject(OrdersDto order) {
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }

        private boolean preStockCheck(ItemKey itemKey, String chargeMode) {
            return null != itemKey && null != itemKey.getItem() && itemKey.getItem().isOpTypeItem(10) && PreStockLimitPlugin.this.chargeMode(chargeMode);
        }
    };
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){
        private static final String PRE_STOCK_QUANTITY_KEY = "__pre_stock_quantity_add";

        @Override
        public void beforeOrderCreate(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) throws Exception {
            if (this.preStockCheck(itemKey, chargeMode)) {
                try {
                    PreStockPointDO point = PreStockLimitPlugin.this.remotePreStockService.getPointStock(itemKey.getItem(), itemKey.getApp());
                    Object objOrderNum = context.getAttribute("orderNum");
                    if (null != point && objOrderNum != null) {
                        PreStockLimitPlugin.this.remotePreStockService.consumeStock(objOrderNum.toString(), itemKey.getApp().getId(), point.getId());
                        context.setAttribute(PRE_STOCK_QUANTITY_KEY, true);
                    }
                }
                catch (Exception e) {
                    log.error("\u9884\u5206\u914d\u6d88\u8d39\u5e93\u5b58\u5931\u8d25");
                    throw e;
                }
            }
        }

        @Override
        public void onOrderCreateException(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, Exception exception, OrdersPlugin.OrdersPluginContext context) {
            if (this.preStockCheck(itemKey, chargeMode)) {
                try {
                    Object objOrderNum = context.getAttribute("orderNum");
                    Boolean hasadd = (Boolean)context.getAttribute(PRE_STOCK_QUANTITY_KEY);
                    if (hasadd != null && hasadd.booleanValue() && objOrderNum != null) {
                        PreStockLimitPlugin.this.remotePreStockService.paybackStock(objOrderNum.toString());
                    }
                    context.remove(PRE_STOCK_QUANTITY_KEY);
                }
                catch (Exception e) {
                    log.error("\u8fd4\u8fd8\u9884\u5206\u914d\u5e93\u5b58\u5931\u8d25\uff0c" + e.getMessage());
                }
            }
        }

        private boolean preStockCheck(ItemKey itemKey, String chargeMode) {
            return null != itemKey && null != itemKey.getItem() && itemKey.getItem().isOpTypeItem(10) && PreStockLimitPlugin.this.chargeMode(chargeMode);
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.ordersEventListener);
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }

    public boolean chargeMode(String chargeMode) {
        if ("hdtool".equals(chargeMode)) {
            return false;
        }
        if ("singlelottery".equals(chargeMode)) {
            return false;
        }
        if ("turntable".equals(chargeMode)) {
            return false;
        }
        if ("manuallottery".equals(chargeMode)) {
            return false;
        }
        if ("game".equals(chargeMode)) {
            return false;
        }
        return !"seckill".equals(chargeMode);
    }
}

