/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime;

import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatAlarmService;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatCheckService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.service.tools.DuibaEvent;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatExchangeRealtime
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(AnticheatExchangeRealtime.class);
    @Autowired
    private RemoteAnticheatCheckService anticheatCheckService;
    @Autowired
    private RemoteAnticheatAlarmService anticheatAlarmService;
    private OrdersEvent.OrdersEventListener listener = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            if (AnticheatExchangeRealtime.this.isPlatformCouponGoodsOrder(order)) {
                return;
            }
            if ("mall".equals(order.getChargeMode()) && "coupon".equals(order.getType())) {
                OrderParams oParams = new OrderParams();
                oParams.setOrderId(order.getId());
                oParams.setDeveloperId(order.getDeveloperId());
                oParams.setAppId(order.getAppId());
                oParams.setConsumerId(order.getConsumerId());
                oParams.setItemId(order.getItemId());
                oParams.setAppItemId(order.getAppItemId());
                oParams.setCouponId(order.getCouponId());
                oParams.setDeveloperBizId(order.getDeveloperBizId());
                oParams.setIp(order.getIp());
                try {
                    AnticheatExchangeRealtime.this.anticheatCheckService.onOrderCreate(oParams);
                }
                catch (Exception e) {
                    log.error("\u9632\u4f5c\u5f0a\uff0c\u521b\u5efa\u8ba2\u5355\u540e\u8bf7\u6c42\u9632\u4f5c\u5f0a\u7cfb\u7edf\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff0corderId=" + order.getId(), (Throwable)e);
                }
            }
        }

        @Override
        public void onOrderSuccess(OrdersDto order) {
            if (AnticheatExchangeRealtime.this.isPlatformCouponGoodsOrder(order)) {
                return;
            }
            if ("mall".equals(order.getChargeMode()) && "coupon".equals(order.getType())) {
                OrderParams oParams = new OrderParams();
                oParams.setOrderId(order.getId());
                oParams.setDeveloperId(order.getDeveloperId());
                oParams.setAppId(order.getAppId());
                oParams.setConsumerId(order.getConsumerId());
                oParams.setItemId(order.getItemId());
                oParams.setAppItemId(order.getAppItemId());
                oParams.setCouponId(order.getCouponId());
                oParams.setDeveloperBizId(order.getDeveloperBizId());
                oParams.setIp(order.getIp());
                try {
                    AnticheatExchangeRealtime.this.anticheatAlarmService.onOrderSuccess(oParams);
                }
                catch (Exception e) {
                    log.error("\u9632\u4f5c\u5f0a\uff0c\u8ba2\u5355\u6210\u529f\u540e\u8bf7\u6c42\u9632\u4f5c\u5f0a\u7cfb\u7edf\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff0corderId=" + order.getId(), (Throwable)e);
                }
            }
        }

        @Override
        public void onOrderFail(OrdersDto order) {
            if (AnticheatExchangeRealtime.this.isPlatformCouponGoodsOrder(order)) {
                return;
            }
            if ("mall".equals(order.getChargeMode()) && "coupon".equals(order.getType()) && DateUtils.getDayStr((Date)new Date()).equals(DateUtils.getDayStr((Date)order.getGmtCreate()))) {
                OrderParams oParams = new OrderParams();
                oParams.setOrderId(order.getId());
                oParams.setDeveloperId(order.getDeveloperId());
                oParams.setAppId(order.getAppId());
                oParams.setConsumerId(order.getConsumerId());
                oParams.setItemId(order.getItemId());
                oParams.setAppItemId(order.getAppItemId());
                oParams.setCouponId(order.getCouponId());
                oParams.setDeveloperBizId(order.getDeveloperBizId());
                oParams.setIp(order.getIp());
                try {
                    AnticheatExchangeRealtime.this.anticheatCheckService.onOrderFail(oParams);
                }
                catch (Exception e) {
                    log.error("\u9632\u4f5c\u5f0a\uff0c\u8ba2\u5355\u5931\u8d25\u540e\u8bf7\u6c42\u9632\u4f5c\u5f0a\u7cfb\u7edf\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff0corderId=" + order.getId(), (Throwable)e);
                }
            }
        }

        @Override
        public void onOrderAuditReject(OrdersDto order) {
        }

        @Override
        public void onOrderAuditPass(OrdersDto order) {
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }
    };

    private boolean isPlatformCouponGoodsOrder(OrdersDto order) {
        return order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype();
    }

    public static String getUaTempSaveKey(Long orderId) {
        return "103-uaorder-" + orderId;
    }

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.listener);
    }
}

