/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime;

import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.api.remoteservice.order.RemoteAnticheatExchangeLogService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.tool.GetDeepTool;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatRealtime
implements InitializingBean {
    @Autowired
    private RemoteAnticheatExchangeLogService anticheatExchangeLogService;

    private boolean isPlatformCouponGoodsOrder(OrdersDto order) {
        return order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype();
    }

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
                if (AnticheatRealtime.this.isPlatformCouponGoodsOrder(order)) {
                    return;
                }
                if ("mall".equals(order.getChargeMode()) && ("coupon".equals(order.getType()) || "object".equals(order.getType()))) {
                    OrderParams orderParams = new OrderParams();
                    orderParams.setAppId(order.getAppId());
                    orderParams.setAppItemId(order.getAppItemId());
                    orderParams.setConsumerId(order.getConsumerId());
                    orderParams.setCouponId(order.getCouponId());
                    orderParams.setDeveloperBizId(order.getDeveloperBizId());
                    orderParams.setDeveloperId(order.getDeveloperId());
                    orderParams.setIp(order.getIp());
                    orderParams.setItemId(order.getItemId());
                    orderParams.setOrderId(order.getId());
                    RequestParams anticheatRequestParams = new RequestParams();
                    anticheatRequestParams.setIp(request.getIp());
                    anticheatRequestParams.setUserAgent(request.getUserAgent());
                    anticheatRequestParams.setDeap(GetDeepTool.getDeap(request, order.getAppId()));
                    AnticheatRealtime.this.anticheatExchangeLogService.insertExchangeLog(orderParams, anticheatRequestParams);
                }
            }

            @Override
            public void onOrderSuccess(OrdersDto order) {
            }

            @Override
            public void onOrderFail(OrdersDto order) {
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }
        });
    }
}

