/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.common.BalanceRemindService;
import cn.com.duiba.paycenter.service.PayCenterService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BalanceRemindRealtime
implements InitializingBean {
    @Autowired
    private BalanceRemindService balanceRemindService;
    @Autowired
    private PayCenterService ayCenterService;
    @Autowired
    private RemoteAppService remoteAppService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
                AppDO app = BalanceRemindRealtime.this.remoteAppService.find(order.getAppId());
                Long money = BalanceRemindRealtime.this.ayCenterService.getBalance(app.getDeveloperId());
                BalanceRemindRealtime.this.balanceRemindService.balanceNotifyIfNecessry(app.getDeveloperId(), money.intValue());
            }

            @Override
            public void onOrderSuccess(OrdersDto order) {
            }

            @Override
            public void onOrderFail(OrdersDto order) {
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }
        });
    }
}

