/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.common.RemoteTradeConsumerFootprintService;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumerFootprintRealtime
implements InitializingBean {
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteTradeConsumerFootprintService consumerFootprintService;

    private boolean isPlatformCouponGoodsOrder(OrdersDto order) {
        return order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype();
    }

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
                if (ConsumerFootprintRealtime.this.isPlatformCouponGoodsOrder(order)) {
                    return;
                }
                if ("mall".equals(order.getChargeMode())) {
                    ItemKey key = ConsumerFootprintRealtime.this.remoteItemKeyService.getItemKeyIncludeDeleted(order.getItemId(), order.getAppItemId(), order.getAppId());
                    String degree = null;
                    if (ConsumerFootprintRealtime.this.isQuantity(key)) {
                        degree = order.getQuantity().toString();
                    } else if ("virtual".equals(key.getItemType())) {
                        degree = order.getBizParams().split(":")[0];
                    }
                    ConsumerFootprintRealtime.this.consumerFootprintService.addFootprint(order.getConsumerId(), order.getId(), key, degree);
                }
            }

            @Override
            public void onOrderFail(OrdersDto order) {
                if (order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype()) {
                    return;
                }
                if ("mall".equals(order.getChargeMode())) {
                    ItemKey key = ConsumerFootprintRealtime.this.remoteItemKeyService.getItemKeyIncludeDeleted(order.getItemId(), order.getAppItemId(), order.getAppId());
                    ConsumerFootprintRealtime.this.consumerFootprintService.rollbackFootprint(order.getConsumerId(), order.getId(), key);
                }
            }

            @Override
            public void onOrderSuccess(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }
        });
    }

    private boolean isQuantity(ItemKey key) {
        return "alipay".equals(key.getItemType()) || "alipaycode".equals(key.getItemType()) || "alipayfast".equals(key.getItemType()) || "phonebill".equals(key.getItemType()) || "phoneflow".equals(key.getItemType()) || "qb".equals(key.getItemType());
    }
}

