/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.order.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.ordercreate.TodayCountService;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.GameOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.GuessOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.HdtoolOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.ManualLotteryEvent;
import cn.com.duiba.order.center.biz.core.event.NgameOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.core.event.QuestionOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.QuizzOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.SingleLotteryEvent;
import cn.com.duiba.order.center.biz.core.event.TurntableEvent;
import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrdersTodayCountRealtime
implements InitializingBean {
    @Autowired
    private TodayCountService todayCountService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByOrders(order);
            }

            @Override
            public void onOrderSuccess(OrdersDto order) {
            }

            @Override
            public void onOrderFail(OrdersDto order) {
                OrdersTodayCountRealtime.this.todayCountService.rollbackExpectByOrders(order);
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }
        });
        DuibaEventsRegister.get().registSingleLotteryEvent(new SingleLotteryEvent.SingleLotteryEventListener(){

            @Override
            public void onOrderCreate(SingleLotteryOrderDto order) {
            }

            @Override
            public void onOrderSuccess(SingleLotteryOrderDto order) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
            }

            @Override
            public void onOrderFail(SingleLotteryOrderDto order) {
            }
        });
        DuibaEventsRegister.get().registTurntableEvent(new TurntableEvent.TurntableEventListener(){

            @Override
            public void onOrderCreate(TurntableOrderDO order) {
            }

            @Override
            public void onOrderSuccess(TurntableOrderDO order) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
            }

            @Override
            public void onOrderFail(TurntableOrderDO order) {
            }
        });
        DuibaEventsRegister.get().registManualLotteryEvent(new ManualLotteryEvent.ManualLotteryEventListener(){

            @Override
            public void onOrderCreate(ManualLotteryOrderDto order) {
            }

            @Override
            public void onOrderSuccess(ManualLotteryOrderDto order) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
            }

            @Override
            public void onOrderFail(ManualLotteryOrderDto order) {
            }
        });
        DuibaEventsRegister.get().registHdtoolOrdersEvent(new HdtoolOrdersEvent.HdtoolOrdersEventListener(){

            @Override
            public void onOrderSuccess(HdtoolOrdersDto order) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
            }

            @Override
            public void onOrderFail(HdtoolOrdersDto order) {
            }

            @Override
            public void onOrderCreate(HdtoolOrdersDto order) {
            }
        });
        DuibaEventsRegister.get().registQuizzOrdersEvent(new QuizzOrdersEvent.QuizzOrdersEventListener(){

            @Override
            public void onOrderSuccess(QuizzOrdersDto order) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
            }

            @Override
            public void onOrderFail(QuizzOrdersDto order) {
            }

            @Override
            public void onOrderCreate(QuizzOrdersDto order) {
            }
        });
        DuibaEventsRegister.get().registGameOrdersEvent(new GameOrdersEvent.GameOrdersEventListener(){

            @Override
            public void onOrderCreate(GameOrdersDto order) {
            }

            @Override
            public void onOrderConsumeSuccess(GameOrdersDto order) {
                if (order.getCredits() != null && order.getCredits() > 0L) {
                    OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
                }
            }

            @Override
            public void onOrderSuccess(GameOrdersDto order) {
            }

            @Override
            public void onOrderFail(GameOrdersDto order) {
            }

            @Override
            public void onOrderConsumerFail(GameOrdersDto order) {
            }
        });
        DuibaEventsRegister.get().registNgameOrdersEvent(new NgameOrdersEvent.NgameOrdersEventListener(){

            @Override
            public void onOrderCreate(NgameOrdersDto order) {
            }

            @Override
            public void onOrderConsumeSuccess(NgameOrdersDto order) {
                if (order.getCredits() != null && order.getCredits() > 0L) {
                    OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
                }
            }

            @Override
            public void onOrderSuccess(NgameOrdersDto order) {
            }

            @Override
            public void onOrderFail(NgameOrdersDto order) {
            }

            @Override
            public void onOrderConsumerFail(NgameOrdersDto order) {
            }
        });
        DuibaEventsRegister.get().registQuestionOrdersEvent(new QuestionOrdersEvent.QuestionOrdersEventListener(){

            @Override
            public void onOrderSuccess(DuibaQuestionAnswerOrdersDto order) {
            }

            @Override
            public void onOrderCreate(DuibaQuestionAnswerOrdersDto order) {
            }

            @Override
            public void onOrderConsumerFail(DuibaQuestionAnswerOrdersDto order) {
            }

            @Override
            public void onOrderConsumeSuccess(DuibaQuestionAnswerOrdersDto order) {
                if (order.getCredits() != null && order.getCredits() > 0L) {
                    OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
                }
            }
        });
        DuibaEventsRegister.get().registGuessOrdersEvent(new GuessOrdersEvent.GuessOrdersEventListener(){

            @Override
            public void onOrderSuccess(GuessOrdersDto order) {
                OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
            }

            @Override
            public void onOrderFail(GuessOrdersDto order) {
            }

            @Override
            public void onOrderCreate(GuessOrdersDto order) {
            }

            @Override
            public void onOrderConsumeSuccess(GuessOrdersDto order) {
                if (order.getCredits() != null && order.getCredits() > 0L) {
                    OrdersTodayCountRealtime.this.todayCountService.addExpectByCredits(order.getAppId(), order.getCredits());
                }
            }
        });
    }
}

