/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.ItemEvent;
import cn.com.duiba.order.center.biz.core.event.OperatingActivityEvent;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.remoteservice.RemoteAppScheduledTasksService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTasksRemoveRealtime
implements InitializingBean {
    @Autowired
    private RemoteAppScheduledTasksService remoteAppScheduledTasksService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registItemEvent(new ItemEvent.ItemEventListener(){

            @Override
            public void onShelfOn(ItemKey itemKey) {
            }

            @Override
            public void onShelfOff(ItemKey itemKey) {
            }

            @Override
            public void onDeleted(ItemKey itemKey) {
                if (itemKey != null && itemKey.getAppItem() != null) {
                    AppItemDO appItem = itemKey.getAppItem();
                    ScheduledTasksRemoveRealtime.this.remoteAppScheduledTasksService.deleteBySourceIdAndSourceType(appItem.getId(), "item");
                }
            }
        });
        DuibaEventsRegister.get().registOperatingActivityEvent(new OperatingActivityEvent.OperatingActivityEventListener(){

            @Override
            public void onDeleted(OperatingActivityDto activity) {
                if (activity != null) {
                    ScheduledTasksRemoveRealtime.this.remoteAppScheduledTasksService.deleteBySourceIdAndSourceType(activity.getId(), "activity");
                }
            }
        });
    }
}

