/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime.fastOrder;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.support.OrderFasterEventLog;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaService;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaServiceLog;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DevDeliverOrderFastRealTime
implements InitializingBean {
    @Autowired
    private OrdersFasterSimpleService remoteOrdersFasterSimpleService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            }

            @Override
            public void onOrderSuccess(final OrdersDto order) {
                if (this.devDeliverCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderSuccess");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = DevDeliverOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 5);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u5f00\u53d1\u5f85\u53d1\u8d27");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderFail(final OrdersDto order) {
                if (this.devDeliverCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderFail");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = DevDeliverOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 5);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u5f00\u53d1\u5f85\u53d1\u8d27");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }

            private boolean devDeliverCondition(OrdersDto order) {
                return order.getType().equals("object") && null == order.getItemId();
            }
        });
    }
}

