/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime.fastOrder;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.supplier_order.RemoteSupplierOrdersService;
import cn.com.duiba.order.center.api.remoteservice.supplier_order.RemoteSupplierProductsService;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.support.OrderFasterEventLog;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaService;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaServiceLog;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuDuDaTimeoutOrderFastRealTime
implements InitializingBean {
    @Autowired
    private RemoteSupplierProductsService remoteSupplierProductsService;
    @Autowired
    private OrdersFasterSimpleService remoteOrdersFasterSimpleService;
    @Autowired
    private RemoteSupplierOrdersService remoteSupplierOrdersService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            }

            @Override
            public void onOrderSuccess(final OrdersDto order) {
                if (this.suDuDaTimeoutCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderSuccess");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = SuDuDaTimeoutOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 2);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u901f\u5ea6\u8fbe\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderFail(final OrdersDto order) {
                if (this.suDuDaTimeoutCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderFail");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = SuDuDaTimeoutOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 2);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u901f\u5ea6\u8fbe\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }

            private boolean suDuDaTimeoutCondition(OrdersDto order) {
                if (order.getChargeMode().equals("mall") || order.getChargeMode().equals("api")) {
                    if (null == order.getSupplierOrderId()) {
                        return false;
                    }
                    if (order.getType().equals("object") || order.getType().equals("coupon") || order.getType().equals("virtual")) {
                        return false;
                    }
                    SupplierOrderDto supplierOrderDO = SuDuDaTimeoutOrderFastRealTime.this.remoteSupplierOrdersService.find(order.getSupplierOrderId());
                    if (null == supplierOrderDO) {
                        return false;
                    }
                    SupplierProductDto supplierProductDO = SuDuDaTimeoutOrderFastRealTime.this.remoteSupplierProductsService.find(supplierOrderDO.getSupplierProductId());
                    if (null == supplierProductDO) {
                        return false;
                    }
                    if (supplierProductDO.getSupplier().equals("phonebill-sududa")) {
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

