/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime.fastOrder;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.support.OrderFasterEventLog;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaService;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaServiceLog;
import cn.com.duiba.service.domain.Tuple;
import cn.com.duiba.service.tools.DuibaEvent;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeoutOrderFasterRealTime
implements InitializingBean {
    @Autowired
    private OrdersFasterSimpleService remoteOrdersFasterSimpleService;
    private ScheduledExecutorService whileService = Executors.newScheduledThreadPool(1);
    private Queue<Tuple.Tuple2<Runnable, Date>> runnables = new LinkedBlockingQueue<Tuple.Tuple2<Runnable, Date>>();

    public TimeoutOrderFasterRealTime() {
        this.whileService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Long now = new Date().getTime();
                while (!TimeoutOrderFasterRealTime.this.runnables.isEmpty() && now - ((Date)((Tuple.Tuple2)TimeoutOrderFasterRealTime.this.runnables.peek())._2()).getTime() > 1000L) {
                    Runnable r = (Runnable)((Tuple.Tuple2)TimeoutOrderFasterRealTime.this.runnables.poll())._1();
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: TimeoutOrderFasterRealTime");
                    ThreadPoolDuibaService.get().submit(r, 1);
                }
            }
        }, 10L, 5L, TimeUnit.SECONDS);
    }

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            }

            @Override
            public void onOrderSuccess(final OrdersDto order) {
                if (this.timeoutCondition(order)) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            int ret = TimeoutOrderFasterRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 1);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    };
                    TimeoutOrderFasterRealTime.this.runnables.add(Tuple.Tuple2.tuple((Object)r, (Object)new Date()));
                }
            }

            @Override
            public void onOrderFail(final OrdersDto order) {
                if (this.timeoutCondition(order)) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            int ret = TimeoutOrderFasterRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 1);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    };
                    TimeoutOrderFasterRealTime.this.runnables.add(Tuple.Tuple2.tuple((Object)r, (Object)new Date()));
                }
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }

            private boolean timeoutCondition(OrdersDto order) {
                if (order.getChargeMode().equals("mall") || order.getChargeMode().equals("api")) {
                    return !order.getType().equals("object") && !order.getType().equals("coupon") && !order.getType().equals("virtual");
                }
                return false;
            }
        });
    }
}

