/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime.fastOrder;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.support.OrderFasterEventLog;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaService;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaServiceLog;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TurnableTimeoutOrderRealTime
implements InitializingBean {
    @Autowired
    private OrdersFasterSimpleService remoteOrdersFasterSimpleService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            }

            @Override
            public void onOrderSuccess(final OrdersDto order) {
                if (this.turntableTimeoutCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderSuccess");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = TurnableTimeoutOrderRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 7);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u5927\u8f6c\u76d8\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderFail(final OrdersDto order) {
                if (this.turntableTimeoutCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderFail");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = TurnableTimeoutOrderRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 7);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u5927\u8f6c\u76d8\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }

            private boolean turntableTimeoutCondition(OrdersDto order) {
                if (order.getChargeMode().equals("turntable") && order.getItemId() != null) {
                    return !order.getType().equals("coupon") && !order.getType().equals("virtual");
                }
                return false;
            }
        });
    }
}

