/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime.fastOrder;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.support.OrderFasterEventLog;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaService;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaServiceLog;
import cn.com.duiba.service.tools.DuibaEvent;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WaitAuditOrderFastRealTime
implements InitializingBean {
    @Autowired
    private OrdersFasterSimpleService remoteOrdersFasterSimpleService;
    private OrdersEvent.OrdersEventListener ordersEventLister = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
        }

        @Override
        public void onOrderSuccess(final OrdersDto order) {
            if (this.waitAuditCondition(order)) {
                ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderSuccess");
                ThreadPoolDuibaService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        int ret = WaitAuditOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 6);
                        if (ret == 1) {
                            OrderFasterEventLog.deleteLog(order, "\u5ba1\u6838");
                        }
                    }
                }, 1);
            }
        }

        @Override
        public void onOrderFail(final OrdersDto order) {
            if (this.waitAuditCondition(order)) {
                ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderFail");
                ThreadPoolDuibaService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        int ret = WaitAuditOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 6);
                        if (ret == 1) {
                            OrderFasterEventLog.deleteLog(order, "\u5ba1\u6838");
                        }
                    }
                }, 1);
            }
        }

        @Override
        public void onOrderAuditPass(final OrdersDto order) {
            if (this.waitAuditCondition(order)) {
                ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderAuditPass");
                ThreadPoolDuibaService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        int ret = WaitAuditOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 6);
                        if (ret == 1) {
                            OrderFasterEventLog.deleteLog(order, "\u5ba1\u6838");
                        }
                    }
                }, 1);
            }
        }

        @Override
        public void onOrderAuditReject(final OrdersDto order) {
            if (this.waitAuditCondition(order)) {
                ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderAuditReject");
                ThreadPoolDuibaService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        int ret = WaitAuditOrderFastRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 6);
                        if (ret == 1) {
                            OrderFasterEventLog.deleteLog(order, "\u5ba1\u6838");
                        }
                    }
                }, 1);
            }
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }

        private boolean waitAuditCondition(OrdersDto order) {
            return StringUtils.isNotBlank((String)order.getAuditStatus());
        }
    };
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){

        @Override
        public void afterOrderCreate(OrdersDto order, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) {
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.ordersEventLister);
    }
}

