/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.kafkaconsumer;

import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.tool.KafkaClient;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DuibaEventsBaseConsumer
implements InitializingBean {
    @Autowired
    KafkaClient kafkaClient;
    @Autowired
    TopicConstant topicConstant;
    ExecutorService executorService;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    abstract int getPool();

    abstract String getEventName();

    abstract Class getEventClass();

    abstract Logger getLog();

    synchronized void start() {
        if (this.executorService != null) {
            return;
        }
        this.executorService = Executors.newFixedThreadPool(this.getPool(), new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-phonebill-Consumer-" + this.i++);
            }
        });
        for (int i = 0; i < this.getPool(); ++i) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Properties props = new Properties();
                        props.put("bootstrap.servers", DuibaEventsBaseConsumer.this.kafkaClient.getBootstrapServers());
                        props.put("group.id", "default");
                        props.put("enable.auto.commit", "false");
                        props.put("session.timeout.ms", "30000");
                        props.put("auto.offset.reset", "earliest");
                        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        KafkaConsumer consumer = new KafkaConsumer(props);
                        consumer.subscribe(Arrays.asList(DuibaEventsBaseConsumer.this.getEventName()));
                        while (!Thread.currentThread().isInterrupted()) {
                            ConsumerRecords records = consumer.poll(100L);
                            for (TopicPartition pt : records.partitions()) {
                                for (ConsumerRecord record : records.records(pt)) {
                                    try {
                                        OrdersEvent oe = (OrdersEvent)JSONObject.parseObject((String)((String)record.value()), OrdersEvent.class);
                                        DuibaEventsBaseConsumer.this.duibaEventsDispatcher.dispatchEvent(oe);
                                    }
                                    catch (Exception e) {
                                        DuibaEventsBaseConsumer.this.getLog().error("OrdersEvent consumer error:", (Throwable)e);
                                    }
                                    finally {
                                        long lastOffset = record.offset();
                                        consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1L)));
                                    }
                                }
                            }
                        }
                        consumer.close();
                    }
                    catch (Exception e) {
                        DuibaEventsBaseConsumer.this.getLog().error("error:", (Throwable)e);
                    }
                }
            });
        }
    }
}

