/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.dao;

import cn.com.duiba.order.center.biz.dao.DatabaseSchema;
import cn.com.duiba.wolf.spring.datasource.AutoRoutingDataSource;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public abstract class TradeBaseDao {
    private static final Logger log = LoggerFactory.getLogger(TradeBaseDao.class);
    @Resource(name="creditsLogSqlSessionTemplate")
    private SqlSessionTemplate creditsLogSqlSessionTemplate;
    @Resource(name="creditsMasterSqlSessionTemplate")
    private SqlSessionTemplate creditsMasterSqlSessionTemplate;
    @Resource(name="ordersConsumerSqlSessionTemplate")
    private SqlSessionTemplate ordersConsumerSqlSessionTemplate;
    @Resource(name="orderHouseSqlSessionTemplate")
    private SqlSessionTemplate orderHouseSqlSessionTemplate;
    @Resource(name="ordersMirrorSqlSessionTemplate")
    private SqlSessionTemplate ordersMirrorSqlSessionTemplate;
    @Resource(name="crecordSqlSessionTemplate")
    private SqlSessionTemplate crecordSqlSessionTemplate;

    private SqlSessionTemplate getSqlSessionTemplate(boolean isForceUseMasterDataSource) {
        DatabaseSchema databaseSchema = this.chooseSchema();
        if (databaseSchema == null) {
            throw new NullPointerException("please set databaseSchema in class:" + this.getClass().getName());
        }
        SqlSessionTemplate sqlSessionTemplate = null;
        switch (databaseSchema) {
            case CREDITS_LOG: {
                sqlSessionTemplate = this.creditsLogSqlSessionTemplate;
                break;
            }
            case CREDITS: {
                sqlSessionTemplate = this.creditsMasterSqlSessionTemplate;
                break;
            }
            case ORDERS_CONSUMER: {
                sqlSessionTemplate = this.ordersConsumerSqlSessionTemplate;
                break;
            }
            case ORDER_HOUSE: {
                sqlSessionTemplate = this.orderHouseSqlSessionTemplate;
                break;
            }
            case ORDERS_MIRROR: {
                sqlSessionTemplate = this.ordersMirrorSqlSessionTemplate;
                break;
            }
            case CRECORD: {
                sqlSessionTemplate = this.crecordSqlSessionTemplate;
                break;
            }
            default: {
                throw new NullPointerException("\u5f53\u4f60\u770b\u5230\u8fd9\u4e2a\u62a5\u9519\u7684\u65f6\u5019,\u4f60\u80af\u5b9a\u6ca1\u6709\u914d\u7f6e\u8fd4\u56de\u6070\u5f53\u7684sqlSessionTemplate,\u9ebb\u70e6\u5c48\u8eab\u8fdb\u6765\u914d\u7f6e\u4e00\u4e0b\u5427");
            }
        }
        DataSource ds = sqlSessionTemplate.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource();
        if (ds instanceof DelegatingDataSource) {
            ds = ((DelegatingDataSource)ds).getTargetDataSource();
        }
        if (ds instanceof AutoRoutingDataSource) {
            AutoRoutingDataSource autoRoutingDataSource = (AutoRoutingDataSource)ds;
            autoRoutingDataSource.determineCurrentLookupKeyByItSelf(isForceUseMasterDataSource);
        }
        return sqlSessionTemplate;
    }

    protected abstract DatabaseSchema chooseSchema();

    public int insert(String statement) {
        return this.getSqlSessionTemplate(true).insert(this.addNameSpace(statement));
    }

    public int delete(String statement) {
        return this.getSqlSessionTemplate(true).delete(this.addNameSpace(statement));
    }

    public int update(String statement) {
        return this.getSqlSessionTemplate(true).update(this.addNameSpace(statement));
    }

    public int delete(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).delete(this.addNameSpace(statement), parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.getSqlSessionTemplate(false).selectList(this.addNameSpace(statement), parameter, rowBounds);
    }

    public void select(String statement, ResultHandler handler) {
        this.getSqlSessionTemplate(false).select(this.addNameSpace(statement), handler);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSqlSessionTemplate(false).selectOne(this.addNameSpace(statement), parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.getSqlSessionTemplate(false).selectMap(this.addNameSpace(statement), parameter, mapKey);
    }

    public int insert(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).insert(this.addNameSpace(statement), parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.getSqlSessionTemplate(false).selectMap(this.addNameSpace(statement), parameter, mapKey, rowBounds);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.getSqlSessionTemplate(false).select(this.addNameSpace(statement), parameter, rowBounds, handler);
    }

    public <E> List<E> selectList(String statement) {
        return this.getSqlSessionTemplate(false).selectList(this.addNameSpace(statement));
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.getSqlSessionTemplate(false).select(this.addNameSpace(statement), parameter, handler);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.getSqlSessionTemplate(false).selectMap(this.addNameSpace(statement), mapKey);
    }

    public int update(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).update(this.addNameSpace(statement), parameter);
    }

    public <T> T selectOne(String statement) {
        return (T)this.getSqlSessionTemplate(false).selectOne(this.addNameSpace(statement));
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSqlSessionTemplate(false).selectList(this.addNameSpace(statement), parameter);
    }

    protected String addNameSpace(String method) {
        return this.getClass().getName() + "." + method;
    }
}

