/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.dao.crecord.impl;

import cn.com.duiba.order.center.biz.dao.DatabaseSchema;
import cn.com.duiba.order.center.biz.dao.TradeBaseDao;
import cn.com.duiba.order.center.biz.dao.crecord.ConsumerExchangeRecordDao;
import cn.com.duiba.order.center.biz.entity.crecord.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.crecord.CrecordSequence;
import cn.com.duiba.trade.center.common.util.TableHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ConsumerExchangeRecordDaoImpl
extends TradeBaseDao
implements ConsumerExchangeRecordDao {
    protected String get1024TableName(Long consumerId) {
        String tableName = "consumer_exchange_record_" + TableHelper.getTableSuffix((Long)consumerId);
        return tableName;
    }

    @Override
    public long getSequenceID() {
        CrecordSequence sequence = new CrecordSequence();
        this.insert("getSequenceID", sequence);
        return sequence.getId();
    }

    @Override
    public ConsumerExchangeRecordEntity find(Long id, long consumerId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", this.get1024TableName(consumerId));
        params.put("id", id);
        return (ConsumerExchangeRecordEntity)this.selectOne("find", params);
    }

    @Override
    public void insert(ConsumerExchangeRecordEntity consumerExchangeRecordDO) {
        consumerExchangeRecordDO.setTableName(this.get1024TableName(consumerExchangeRecordDO.getConsumerId()));
        long id = this.getSequenceID();
        consumerExchangeRecordDO.setId(id);
        this.insert("insert", consumerExchangeRecordDO);
    }

    @Override
    public int updateSwitchs(Long id, Long switchs, Long orderId, long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("switchs", switchs);
        paramMap.put("orderId", orderId);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return this.update("updateSwitchs", paramMap);
    }

    @Override
    public int updateOrderId(Long id, Long orderId, long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("orderId", orderId);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return this.update("updateOrderId", paramMap);
    }

    @Override
    public int updateJson(Long id, String json, long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("json", json);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return this.update("updateJson", paramMap);
    }

    @Override
    public int updateOverDue(Long id, Date overDue, Long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("overDue", overDue);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return this.update("updateOverDue", paramMap);
    }

    @Override
    public List<ConsumerExchangeRecordEntity> findConsumerExchangeRecord(Map<String, Object> queryMap, long consumerId) {
        queryMap.put("tableName", this.get1024TableName(consumerId));
        return this.selectList("findConsumerExchangeRecord", queryMap);
    }

    @Override
    public List<ConsumerExchangeRecordEntity> findConsumerExchangeRecordValid(Map<String, Object> queryMap, long consumerId) {
        queryMap.put("tableName", this.get1024TableName(consumerId));
        return this.selectList("findConsumerExchangeRecordValid", queryMap);
    }

    @Override
    public List<ConsumerExchangeRecordEntity> findConsumerExchangeRecordInvalid(Map<String, Object> queryMap, long consumerId) {
        queryMap.put("tableName", this.get1024TableName(consumerId));
        return this.selectList("findConsumerExchangeRecordInvalid", queryMap);
    }

    @Override
    public ConsumerExchangeRecordEntity findByOrderId(Long orderId, Long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orderId", orderId);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return (ConsumerExchangeRecordEntity)this.selectOne("findByOrderId", paramMap);
    }

    @Override
    public ConsumerExchangeRecordEntity findByRelationIdAndType(Long relationId, Integer type, Long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("relationId", relationId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("type", type);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return (ConsumerExchangeRecordEntity)this.selectOne("findByRelationIdAndType", paramMap);
    }

    @Override
    public ConsumerExchangeRecordEntity findGameByRelationIdAndType(Long relationId, Integer type, Long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("relationId", relationId);
        paramMap.put("type", type);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return (ConsumerExchangeRecordEntity)this.selectOne("findGameByRelationIdAndType", paramMap);
    }

    @Override
    public ConsumerExchangeRecordEntity findGuessByRelationIdAndType(Long relationId, Integer type, Long consumerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("relationId", relationId);
        paramMap.put("type", type);
        paramMap.put("tableName", this.get1024TableName(consumerId));
        return (ConsumerExchangeRecordEntity)this.selectOne("findGuessByRelationIdAndType", paramMap);
    }

    @Override
    public List<ConsumerExchangeRecordEntity> findConsumerExchangeRecordPptv(Long consumerId, Long minId, Integer max) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("minId", minId);
        queryMap.put("max", max);
        queryMap.put("consumerId", consumerId);
        queryMap.put("tableName", this.get1024TableName(consumerId));
        return this.selectList("findConsumerExchangeRecordPptv", queryMap);
    }

    @Override
    public List<ConsumerExchangeRecordEntity> findGameRecord(Long consumerId, Integer type, Integer offset, Integer max) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("consumerId", consumerId);
        queryMap.put("type", type);
        queryMap.put("offset", offset);
        queryMap.put("max", max);
        queryMap.put("tableName", this.get1024TableName(consumerId));
        return this.selectList("findGameRecord", queryMap);
    }

    @Override
    public ConsumerExchangeRecordEntity findOneRecordInvalid(long consumerId) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("consumerId", consumerId);
        queryMap.put("tableName", this.get1024TableName(consumerId));
        return (ConsumerExchangeRecordEntity)this.selectOne("findOneRecordInvalid", queryMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CRECORD;
    }
}

