/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.dao.orders.bigtable.impl;

import cn.com.duiba.order.center.biz.dao.DatabaseSchema;
import cn.com.duiba.order.center.biz.dao.TradeBaseDao;
import cn.com.duiba.order.center.biz.dao.orders.bigtable.BigTableOrdersSimpleDao;
import cn.com.duiba.order.center.biz.entity.orders.Orders4BalanceCheckEntity;
import cn.com.duiba.order.center.biz.entity.orders.OrdersEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class BigTableOrdersSimpleDaoImpl
extends TradeBaseDao
implements BigTableOrdersSimpleDao {
    @Override
    public OrdersEntity find(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (OrdersEntity)this.selectOne("find", paramMap);
    }

    @Override
    public List<OrdersEntity> findAllByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.selectList("findAllByIds", paramMap);
    }

    @Override
    public OrdersEntity findByOrderNum(String orderNum) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderNum", orderNum);
        return (OrdersEntity)this.selectOne("findByOrderNum", paramMap);
    }

    @Override
    public List<OrdersEntity> findAllByOrderNums(List<String> orderNums) {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("orderNums", orderNums);
        return this.selectList("findAllByOrderNums", paramMap);
    }

    @Override
    public Long findDuibaOrderCountByDateAndAppId(String statdate, Long appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("statdate", statdate);
        paramMap.put("appId", appId);
        return (Long)this.selectOne("findDuibaOrderCountByDateAndAppId", paramMap);
    }

    @Override
    public Long findDuibaOrderCountByDate(String statdate) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("statdate", statdate);
        return (Long)this.selectOne("findDuibaOrderCountByDate", paramMap);
    }

    @Override
    public OrdersEntity select4updatelock(Long orderId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("orderId", orderId);
        return (OrdersEntity)this.selectOne("select4updatelock", paramMap);
    }

    @Override
    public List<Long> findIdsBetween(Long start, Long end) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("start", start);
        paramMap.put("end", end);
        return this.selectList("findIdsBetween", paramMap);
    }

    @Override
    public List<OrdersEntity> findAllPayOrdersByFinishTime(Date startTime, Date endTime) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramsMap.put("startTime", sdf.format(startTime));
        paramsMap.put("endTime", sdf.format(endTime));
        return this.selectList("findAllPayOrdersByFinishTime", paramsMap);
    }

    @Override
    public List<Orders4BalanceCheckEntity> findAllDuibaPayOrdersByFinishTime(Date startTime, Date endTime) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramsMap.put("startTime", sdf.format(startTime));
        paramsMap.put("endTime", sdf.format(endTime));
        return this.selectList("findAllDuibaPayOrdersByFinishTime", paramsMap);
    }

    @Override
    public Orders4BalanceCheckEntity find4BalanceCheckById(Long id) {
        return (Orders4BalanceCheckEntity)this.selectOne("find4BalanceCheckById", id);
    }

    @Override
    public List<Long> findOrderIdsByDeveloperIds(List<Long> developerIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("developerIds", developerIds);
        return this.selectList("findOrderIdsByDeveloperIds", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.ORDER_HOUSE;
    }
}

