/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.dao.orders.consumer.impl;

import cn.com.duiba.order.center.biz.bo.OrderSyncBo;
import cn.com.duiba.order.center.biz.dao.DatabaseSchema;
import cn.com.duiba.order.center.biz.dao.orders.consumer.ConsumerOrderBaseDao;
import cn.com.duiba.order.center.biz.dao.orders.consumer.OrdersStatusChangeDao;
import cn.com.duiba.trade.center.common.util.TableHelper;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OrdersStatusChangeDaoImpl
extends ConsumerOrderBaseDao
implements OrdersStatusChangeDao {
    @Autowired
    private OrderSyncBo orderSyncBo;
    private static final int SAFE_LEN = 200;

    @Override
    public int doAuditPass(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        int ret = this.update("auditPass", paramMap);
        return ret;
    }

    @Override
    public int doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("error4consumer", TableHelper.subString((String)error4consumer, (int)200));
        paramMap.put("error4developer", TableHelper.subString((String)error4developer, (int)200));
        paramMap.put("error4admin", TableHelper.subString((String)error4admin, (int)200));
        paramMap.put("failType", failType);
        int ret = this.update("auditReject", paramMap);
        return ret;
    }

    @Override
    public int doMakeSuccess(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus) throws Exception {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("duibaPayStatus", duibaPayStatus);
        paramMap.put("consumerPayStatus", consumerPayStatus);
        paramMap.put("payStatus", payStatus);
        int ret = this.update("makeSuccess", paramMap);
        return ret;
    }

    @Override
    public int doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice) throws Exception {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("duibaPayStatus", duibaPayStatus);
        paramMap.put("consumerPayStatus", consumerPayStatus);
        paramMap.put("consumerPaybackPrice", consumerPaybackPrice);
        paramMap.put("payStatus", payStatus);
        int ret = this.update("makeFail", paramMap);
        return ret;
    }

    @Override
    public Integer doForceConsumeSuccess(Long orderId, Long consumerId, String error4admin) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("error4admin", TableHelper.subString((String)error4admin, (int)200));
        int ret = this.update("doForceConsumeSuccess", paramMap);
        return ret;
    }

    @Override
    public Integer doMakeConsumeSuccess(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        int ret = this.update("doMakeConsumeSuccess", paramMap);
        return ret;
    }

    @Override
    public Integer doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("failType", failType);
        paramMap.put("error4consumer", TableHelper.subString((String)error4consumer, (int)200));
        paramMap.put("error4developer", TableHelper.subString((String)error4developer, (int)200));
        paramMap.put("error4admin", TableHelper.subString((String)error4admin, (int)200));
        int ret = this.update("doMakeConsumeFail", paramMap);
        return ret;
    }

    @Override
    public Integer doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("supplierOrderId", supplierOrderId);
        paramMap.put("bizParams", bizParams);
        paramMap.put("brief", brief);
        int ret = this.update("doUpdateAllowInputUsed", paramMap);
        return ret;
    }

    @Override
    public Integer doUpdateAllowInputUsed4Object(Long orderId, Long consumerId, Long supplierOrderId, String bizParams) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("supplierOrderId", supplierOrderId);
        paramMap.put("bizParams", bizParams);
        int ret = this.update("doUpdateAllowInputUsed4Object", paramMap);
        return ret;
    }

    @Override
    public Integer updatePayOrderStatus(Long orderId, Long consumerId, String payStatus) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("payStatus", payStatus);
        int ret = this.update("updatePayOrderStatus", paramMap);
        return ret;
    }

    @Override
    public Integer updateDuibaPayOrderStatus(Long orderId, Long consumerId, String duibaPayStatus) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("duibaPayStatus", duibaPayStatus);
        int ret = this.update("updateDuibaPayOrderStatus", paramMap);
        return ret;
    }

    @Override
    public Integer doDeleteOrdersByOrderId(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        int ret = this.update("doDeleteOrdersByOrderId", paramMap);
        return ret;
    }

    @Override
    public Integer doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        int ret = this.update("doAmbPaySuccess", paramMap);
        return ret;
    }

    @Override
    public Integer doAmbConsumerPayStatusPayBack(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        int ret = this.update("doAmbPayBack", paramMap);
        return ret;
    }

    @Override
    public Integer doAmbStatusAfterSend(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        int ret = this.update("doAmbStatusAfterSend", paramMap);
        return ret;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.ORDERS_CONSUMER;
    }
}

