/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.dao.orders.consumer.impl;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.biz.dao.DatabaseSchema;
import cn.com.duiba.order.center.biz.dao.orders.consumer.ConsumerOrderBaseDao;
import cn.com.duiba.order.center.biz.dao.orders.consumer.OrdersTextChangeDao;
import cn.com.duiba.order.center.biz.entity.orders.OrdersEntity;
import cn.com.duiba.trade.center.common.util.IdGenerator;
import cn.com.duiba.trade.center.common.util.TableHelper;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OrdersTextChangeDaoImpl
extends ConsumerOrderBaseDao
implements OrdersTextChangeDao {
    @Autowired
    private RemoteIDMakerService remoteIDMakerService;
    private static final int SAFE_LEN = 200;

    @Override
    public long getSequenceID() {
        DubboResult ret = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.ORDER.getType());
        if (!ret.isSuccess()) {
            throw new RuntimeException("ID\u751f\u6210\u5931\u8d25");
        }
        return (Long)ret.getResult();
    }

    @Override
    public void insert(OrdersEntity order) throws Exception {
        if (StringUtils.isBlank((String)order.getPayStatus()) || StringUtils.isBlank((String)order.getDuibaPayStatus()) || StringUtils.isBlank((String)order.getConsumerPayStatus())) {
            throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        long sequenceid = this.getSequenceID();
        String orderId = sequenceid + "" + TableHelper.getTableSuffix((Long)order.getConsumerId());
        order.setId(Long.valueOf(orderId));
        order.setOrderNum(IdGenerator.generate((long)sequenceid, (long)order.getConsumerId()));
        order.setTableName(this.getTableNameStr(order.getConsumerId()));
        this.insert("insert", order);
    }

    @Override
    public Integer updateAllowInputAndTips(Long orderId, Long consumerId, Boolean allowInput, String allowInputTips) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("allowInputAgain", allowInput);
        paramMap.put("allowInputTips", allowInputTips);
        paramMap.put("orderId", orderId);
        int ret = this.update("updateAllowInputAndTips", paramMap);
        return ret;
    }

    @Override
    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage, String error4Consumer, String error4Develper, String error4Admin) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("failType", failType);
        paramMap.put("errorMessage", TableHelper.subString((String)errorMessage, (int)200));
        paramMap.put("error4Consumer", TableHelper.subString((String)error4Consumer, (int)200));
        paramMap.put("error4Developer", TableHelper.subString((String)error4Develper, (int)200));
        paramMap.put("error4Admin", TableHelper.subString((String)error4Admin, (int)200));
        paramMap.put("orderId", orderId);
        int ret = this.update("updateErrorMessageAndFailType", paramMap);
        return ret;
    }

    @Override
    public void releaseCouponByOrderId(Long orderId, Long consumerId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        this.update("releaseCouponByOrderId", paramMap);
    }

    @Override
    public Integer updateSupplierOrderId(Long orderId, Long consumerId, Long supplierOrderId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("supplierOrderId", supplierOrderId);
        paramMap.put("orderId", orderId);
        int ret = this.update("updateSupplierOrderId", paramMap);
        return ret;
    }

    @Override
    public Integer updateDevelopBizId(Long orderId, Long consumerId, String developBizId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("developBizId", developBizId);
        paramMap.put("orderId", orderId);
        int ret = this.update("updateDevelopBizId", paramMap);
        return ret;
    }

    @Override
    public Integer updateNotify(Long orderId, Long consumerId, Integer notify) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("notify", notify);
        paramMap.put("orderId", orderId);
        int ret = this.update("updateNotify", paramMap);
        return ret;
    }

    @Override
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("lastSendTime", lastSendTime);
        paramMap.put("orderId", orderId);
        int ret = this.update("updateLastSendTime", paramMap);
        return ret;
    }

    @Override
    public int updateErrorInfo(Long orderId, Long consumerId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("error4consumer", error4consumer);
        paramMap.put("error4admin", error4admin);
        paramMap.put("error4developer", error4developer);
        int ret = this.update("updateErrorInfo", paramMap);
        return ret;
    }

    @Override
    public int updateSubOrderIdById(Long orderId, Long consumerId, Long subId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("subId", subId);
        int ret = this.update("updateSubOrderIdById", paramMap);
        return ret;
    }

    @Override
    public int updateConsumerPayBackPrice(Long orderId, Long consumerId, Long consumerPayBackPrice) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("consumerPayBackPrice", consumerPayBackPrice);
        int ret = this.update("updateConsumerPayBackPrice", paramMap);
        return ret;
    }

    @Override
    public int updateCouponId(Long orderId, Long consumerId, Long couponId) {
        Map<String, Object> paramMap = this.getTableName(consumerId);
        paramMap.put("orderId", orderId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("couponId", couponId);
        int ret = this.update("updateCouponId", paramMap);
        return ret;
    }

    @Override
    protected String getTableNameStr(long consumerId) {
        String tableName = "orders_" + TableHelper.getTableSuffix((Long)consumerId);
        return tableName;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.ORDERS_CONSUMER;
    }
}

