/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.plugin;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.tools.DuibaEvent;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaPluginEventsDispatcher {
    private static Logger log = LoggerFactory.getLogger(DuibaPluginEventsDispatcher.class);
    private static DuibaPluginEventsDispatcher dispatcher = new DuibaPluginEventsDispatcher();

    public static DuibaPluginEventsDispatcher get() {
        return dispatcher;
    }

    public void triggerAfterOrderCreate(OrdersDto order, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) {
        for (OrdersPlugin p : new ArrayList<OrdersPlugin>(DuibaPluginRegister.get().plugins)) {
            try {
                p.afterOrderCreate(order, params, context);
            }
            catch (Exception e) {
                log.error(p.getClass().getName() + " process error", (Throwable)e);
            }
        }
    }

    public void triggerBeforeOrderCreate(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) throws Exception {
        for (OrdersPlugin p : new ArrayList<OrdersPlugin>(DuibaPluginRegister.get().plugins)) {
            p.beforeOrderCreate(itemKey, consumer, chargeMode, params, context);
        }
    }

    public void triggerOnOrderCreateException(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, Exception exception, OrdersPlugin.OrdersPluginContext context) {
        for (OrdersPlugin p : new ArrayList<OrdersPlugin>(DuibaPluginRegister.get().plugins)) {
            try {
                p.onOrderCreateException(itemKey, consumer, chargeMode, params, exception, context);
            }
            catch (Exception e) {
                log.error(p.getClass().getName() + " process error", (Throwable)e);
            }
        }
    }
}

