/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.plugin.impl.plugin_impl;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.item.domain.dataobject.ConsumerLimitRecordDO;
import cn.com.duiba.service.item.remoteservice.RemoteConsumerLimitRecordService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.tools.DuibaEvent;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumerTakeOrderPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ConsumerTakeOrderPlugin.class);
    @Autowired
    private RemoteConsumerLimitRecordService remoteConsumerLimitRecordService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){

        @Override
        public void afterOrderCreate(OrdersDto order, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) {
            try {
                if ("mall".equals(order.getChargeMode())) {
                    ItemKey itemKey = ConsumerTakeOrderPlugin.this.remoteItemKeyService.getItemKey(order.getItemId(), order.getAppItemId(), order.getAppId());
                    Integer limitCount = null;
                    String degree = null;
                    if (itemKey.isItemMode()) {
                        limitCount = itemKey.getItem().getLimitCount();
                        if ("coupon".equals(itemKey.getItemType()) && "batch".equals(itemKey.getItem().getLimitScope())) {
                            degree = itemKey.getItem().getBatchId().toString();
                        }
                    } else if (itemKey.isDuibaAppItemMode()) {
                        if (itemKey.getItem().getLimitCount() != null) {
                            limitCount = itemKey.getItem().getLimitCount();
                            if ("coupon".equals(itemKey.getItemType()) && "batch".equals(itemKey.getItem().getLimitScope())) {
                                degree = itemKey.getItem().getBatchId().toString();
                            }
                        } else if (itemKey.getAppItem().getLimitCount() != null) {
                            limitCount = itemKey.getAppItem().getLimitCount();
                            if ("coupon".equals(itemKey.getItemType()) && "batch".equals(itemKey.getAppItem().getLimitScope())) {
                                degree = itemKey.getAppItem().getBatchId().toString();
                            }
                        }
                        if (itemKey.getItem().isDegree()) {
                            degree = order.getQuantity().toString();
                            String customPrice = itemKey.getAppItem() != null ? itemKey.getAppItem().getCustomPrice() : itemKey.getItem().getCustomPrice();
                            PriceDegree pd = new PriceDegree(customPrice);
                            Map map = pd.getLimitByDegree(degree);
                            limitCount = map != null && StringUtils.isNotBlank((String)((String)map.get("limitCount"))) ? Integer.valueOf((String)map.get("limitCount")) : null;
                        }
                    } else if (itemKey.isSelfAppItemMode()) {
                        limitCount = itemKey.getAppItem().getLimitCount();
                        if ("coupon".equals(itemKey.getItemType()) && itemKey.getAppItem().getLimitScope().equals("batch")) {
                            degree = itemKey.getAppItem().getBatchId().toString();
                        } else if ("virtual".equals(itemKey.getItemType())) {
                            degree = PriceDegree.getDegree((String)order.getBizParams());
                        }
                    }
                    if (limitCount != null && limitCount > 0) {
                        ConsumerLimitRecordDO recrod = new ConsumerLimitRecordDO(true);
                        recrod.setConsumerId(order.getConsumerId());
                        recrod.setAppItemId(order.getAppItemId());
                        recrod.setItemId(order.getItemId());
                        recrod.setItemKey(order.getAppItemId(), order.getItemId());
                        recrod.setSubKey(degree);
                        recrod.setSourceId(order.getId());
                        recrod.setSourceType(ConsumerLimitRecordDO.SourceTypeOrder);
                        ConsumerTakeOrderPlugin.this.remoteConsumerLimitRecordService.insert(recrod);
                    }
                }
            }
            catch (Exception e) {
                log.error("afterOrderCreate.insert.consumerLimitRecord error:", (Throwable)e);
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }
}

