/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.plugin.impl.plugin_impl;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.orders_extra.OrdersExtraDto;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders_extra.OrdersExtraService;
import cn.com.duiba.service.tools.DuibaEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrdersExtraPlugin
implements InitializingBean {
    @Autowired
    private OrdersExtraService ordersExtraService;
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){

        @Override
        public void afterOrderCreate(OrdersDto order, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) {
            if (!"api".equals(order.getChargeMode())) {
                this.work(order, params);
            }
        }

        private void work(OrdersDto order, DuibaEvent.RequestParams params) {
            OrdersExtraDto oe = new OrdersExtraDto();
            oe.setUserAgent(params.getUserAgent());
            oe.setTransfer(OrdersExtraPlugin.this.getTransfer(params));
            OrdersExtraPlugin.this.ordersExtraService.updateOrdersExtraProperty(order.getId(), "orders", oe);
        }
    };

    private String getTransfer(HttpServletRequest request) {
        Cookie[] cs = request.getCookies();
        if (cs != null) {
            for (Cookie c : cs) {
                if (!"transfer".equals(c.getName())) continue;
                return c.getValue();
            }
        }
        return null;
    }

    private String getTransfer(DuibaEvent.RequestParams params) {
        if (params != null) {
            return params.getCookies("transfer");
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }
}

