/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.common;

import cn.com.duiba.order.center.biz.service.common.SmsRemindService;
import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.remoteservice.RemoteDeveloperService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BalanceRemindService {
    private Logger log = LoggerFactory.getLogger(BalanceRemindService.class);
    @Autowired
    private SmsRemindService smsRemindService;
    @Autowired
    private RemoteDeveloperService remoteDeveloperService;

    public void balanceNotifyIfNecessry(Long developerId, Integer balance) {
        boolean isbw;
        DeveloperDO developer = this.remoteDeveloperService.find(developerId);
        Date date = new Date();
        boolean bl = isbw = DateUtils.betweenHHmmInString((String)DateUtils.getMinuteOnlyStr((Date)date), (String)"08:00", (String)"22:00") == 1;
        if (developer.getRemindMoney() != null && developer.getRemindMoney() > balance && isbw && (developer.getLastRemindTime() == null || date.getTime() - developer.getLastRemindTime().getTime() > 86400000L) && developer.getPhone() != null) {
            DeveloperDO d = new DeveloperDO(developerId);
            d.setLastRemindTime(new Date());
            this.remoteDeveloperService.updateLastRemindTime(developerId, new Date());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String remind = developer.getCompany() + "\uff0c\u60a8\u7684\u4f59\u989d\u5df2\u4f4e\u4e8e\u9884\u8bbe\u63d0\u9192\u989d\u5ea6\uff08" + developer.getRemindMoney() / 100 + "\u5143\uff09\uff0c\u4e3a\u4e86\u60a8\u7684\u79ef\u5206\u5546\u57ce\u6b63\u5e38\u8fd0\u884c\uff0c\u8bf7\u53ca\u65f6\u5145\u503c\u3002" + sdf.format(new Date());
            try {
                this.smsRemindService.sendBalanceAlarmSms(developer.getPhone(), remind);
            }
            catch (Exception e) {
                this.log.error("smsRemindService.sendSms", (Throwable)e);
            }
        }
    }
}

