/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.AlipayBatchExecutor;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.AlipayUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class AlipayOfficialSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(AlipayOfficialSupplier2.class);
    private String url;
    private String account;
    private String partner;
    private String md5Key;
    private String notifyUrl;
    @Autowired
    private AlipayBatchExecutor alipayBatchExecutor;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;
    private static ScheduledExecutorService delayRetrySchedule = Executors.newSingleThreadScheduledExecutor();
    public static final String MAX_VISIT_LIMIT = "MAX_VISIT_LIMIT";
    public static final String RECEIVE_USER_NOT_EXIST = "RECEIVE_USER_NOT_EXIST";
    public static final String ACCOUN_NAME_NOT_MATCH = "ACCOUN_NAME_NOT_MATCH";
    public static final String ILLEGAL_USER_STATUS = "ILLEGAL_USER_STATUS";
    public static final String ERROR_OTHER_NOT_REALNAMED = "ERROR_OTHER_NOT_REALNAMED";

    public static AlipayOfficialRequest buildRequestData(String orderNum, String alipay, String realname, Integer quantity, String memo) {
        AlipayOfficialRequest req = new AlipayOfficialRequest(orderNum, alipay, realname, quantity, memo);
        return req;
    }

    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("alipay-official")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u5b98\u65b9\u652f\u4ed8\u5b9d\u8ba2\u5355");
        }
        AlipayOfficialRequest request = null;
        if (!(req instanceof AlipayOfficialRequest)) {
            throw new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        request = (AlipayOfficialRequest)req;
        this.alipayBatchExecutor.addAlipayOrder(request);
        AlipayOfficialResponse resp = new AlipayOfficialResponse();
        so.setStatus("send");
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setStatus(so.getStatus());
        so4u.setSendTime(so.getSendTime());
        this.supplierOrdersService.update(so4u);
        HttpRequestLogDto log = new HttpRequestLogDto(true);
        log.setConsumerId(order.getConsumerId());
        log.setAppId(order.getAppId());
        log.setOrderId(order.getId());
        log.setUrl("submit in queue");
        log.setResp(resp.getSupplierBody());
        log.setTag(this.getSupplierName());
        log.setType("ToSupplier");
        StatHttpRequestLog.log(log);
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("alipay-official")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u5b98\u65b9\u652f\u4ed8\u5b9d\u8ba2\u5355"));
                }
            });
            return;
        }
        AlipayOfficialRequest request = null;
        if (!(req instanceof AlipayOfficialRequest)) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e"));
                }
            });
            return;
        }
        request = (AlipayOfficialRequest)req;
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        try {
            this.messageService.sendMsg(this.topicConstant.getAlipayRequest(), JSONObject.toJSONString((Object)request));
        }
        catch (Exception e1) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
        final AlipayOfficialResponse resp = new AlipayOfficialResponse();
        so.setStatus("send");
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setStatus(so.getStatus());
        so4u.setSendTime(so.getSendTime());
        this.supplierOrdersService.update(so4u);
        HttpRequestLogDto log = new HttpRequestLogDto(true);
        log.setConsumerId(order.getConsumerId());
        log.setAppId(order.getAppId());
        log.setOrderId(order.getId());
        log.setUrl("submit in queue");
        log.setResp(resp.getSupplierBody());
        log.setTag(this.getSupplierName());
        log.setType("ToSupplier");
        StatHttpRequestLog.log(log);
        es.submit(new Runnable(){

            @Override
            public void run() {
                callback.onFinish(resp);
            }
        });
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSupplierName() {
        return "alipay-official";
    }

    protected String generateRequestUrl(SupplierData.SupplierExchangeRequest req, OrdersDto order) throws Exception {
        String url = this.url;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        AlipayOfficialRequest request = null;
        if (!(req instanceof AlipayOfficialRequest)) {
            throw new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        request = (AlipayOfficialRequest)req;
        if (request.getMemo() == null) {
            request.setMemo(order.getBizParams().split(":")[2]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String price = new DecimalFormat("#.##").format(order.getFacePrice() / 100);
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "batch_trans_notify_no_pwd");
        sParaTemp.put("partner", this.partner);
        sParaTemp.put("_input_charset", "utf-8");
        sParaTemp.put("notify_url", this.notifyUrl);
        sParaTemp.put("email", this.account);
        sParaTemp.put("account_name", "\u676d\u5dde\u5151\u5427\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8");
        sParaTemp.put("pay_date", sdf.format(new Date()));
        sParaTemp.put("batch_no", request.getOrderNum());
        sParaTemp.put("batch_fee", price);
        sParaTemp.put("batch_num", "1");
        sParaTemp.put("detail_data", request.getOrderNum() + "^" + request.getAlipay() + "^" + request.getRealname() + "^" + price + "^" + request.getMemo());
        Map<String, String> sPara = AlipayUtil.buildRequestPara(sParaTemp, this.md5Key);
        for (String key : sPara.keySet()) {
            url = url + key + "=" + URLEncoder.encode(sPara.get(key), "utf-8") + "&";
        }
        return url;
    }

    protected String getResponseBody(String completeUrl) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(completeUrl);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        return body;
    }

    protected String fetchErrorInResponseBody(String body) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        if (root.getChild("is_success").getValue().equalsIgnoreCase("T") && root.getChild("error").getValue().equalsIgnoreCase("SUCCESS")) {
            return null;
        }
        if (root.getChild("is_success").getValue().equalsIgnoreCase("F")) {
            String error = root.getChild("error").getValue();
            return error;
        }
        return root.getChild("error").getValue();
    }

    protected static synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (delayRetrySchedule == null) {
            delayRetrySchedule = Executors.newSingleThreadScheduledExecutor();
        }
        return delayRetrySchedule;
    }

    protected void submitRetryTask(final Long orderId, final String url, final int maxTryTimes) {
        AlipayOfficialSupplier2.getScheduledExecutorService().schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HttpRequestLogDto hrl = new HttpRequestLogDto(true);
                hrl.setOrderId(orderId);
                hrl.setUrl(url);
                hrl.setType("ToSupplier");
                hrl.setTag("ALIPAY_RETRY");
                String body = AlipayOfficialSupplier2.this.getResponseBody(url);
                String error = AlipayOfficialSupplier2.this.fetchErrorInResponseBody(body);
                if (error != null) {
                    if (AlipayOfficialSupplier2.MAX_VISIT_LIMIT.equals(error)) {
                        int newMaxTryTimes = maxTryTimes - 1;
                        if (newMaxTryTimes > 0) {
                            AlipayOfficialSupplier2.this.submitRetryTask(orderId, url, newMaxTryTimes);
                        }
                    } else {
                        OrdersDto order = new OrdersDto(orderId);
                        order.setError4Admin(AlipayUtil.errorCodeMapping(error));
                        order.setError4Developer(AlipayUtil.errorCodeMapping4Dev(error));
                        order.setError4Consumer(AlipayUtil.errorCodeMapping4Consumer(error));
                        AlipayOfficialSupplier2.this.ordersTextChangeService.updateErrorMessageAndFailType(order.getId(), order.getConsumerId(), null, null, order.getError4Consumer(), order.getError4Developer(), order.getError4Admin());
                    }
                }
                hrl.setResp(body);
                StatHttpRequestLog.log(hrl);
                return null;
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public static void main(String[] args) {
        final Date date = new Date();
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                System.out.println(new Date().getTime() - date.getTime());
                return null;
            }
        };
        for (int i = 0; i < 10; ++i) {
            AlipayOfficialSupplier2.getScheduledExecutorService().schedule(c, 10L, TimeUnit.SECONDS);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPartner() {
        return this.partner;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public String getMd5Key() {
        return this.md5Key;
    }

    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    @Override
    public void supplierCallback(SupplierResponse response) {
    }

    public static class AlipayOfficialResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class AlipayOfficialRequest
    implements SupplierData.SupplierExchangeRequest {
        private String orderNum;
        private String alipay;
        private String realname;
        private Integer quantity;
        private String memo;

        public AlipayOfficialRequest(String orderNum, String alipay, String realname, Integer quantity, String memo) {
            this.orderNum = orderNum;
            this.alipay = alipay;
            this.realname = realname;
            this.quantity = quantity;
            this.memo = memo;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public String getAlipay() {
            return this.alipay;
        }

        public void setAlipay(String alipay) {
            this.alipay = alipay;
        }

        public String getRealname() {
            return this.realname;
        }

        public void setRealname(String realname) {
            this.realname = realname;
        }

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public String getMemo() {
            return this.memo;
        }

        public void setMemo(String memo) {
            this.memo = memo;
        }
    }
}

