/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import java.math.BigDecimal;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CouponSupplier2
extends BaseSupplier2 {
    @Autowired
    private RemoteCouponService remoteCouponService;

    public static CouponRequest buildRequestData(String orderNum) {
        CouponRequest req = new CouponRequest(orderNum);
        return req;
    }

    @Override
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        Long couponId = order.getCouponId();
        if (!order.getType().equals("coupon")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u4f18\u60e0\u5238\u8ba2\u5355");
        }
        CouponResponse resp = new CouponResponse();
        resp.setSuccess(true);
        this.remoteCouponService.useCoupon4Order(couponId);
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        Long couponId = order.getCouponId();
        if (!order.getType().equals("coupon")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u4f18\u60e0\u5238\u8ba2\u5355"));
                }
            });
            return;
        }
        try {
            final CouponResponse resp = new CouponResponse();
            resp.setSuccess(true);
            this.remoteCouponService.useCoupon4Order(couponId);
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onFinish(resp);
                }
            });
        }
        catch (Exception e) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e);
                }
            });
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSupplierName() {
        return "coupon-exchange";
    }

    @Override
    public void supplierCallback(SupplierResponse response) {
    }

    public static class CouponResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class CouponRequest
    implements SupplierData.SupplierExchangeRequest {
        private String orderNum;

        public CouponRequest(String orderNum) {
            this.orderNum = orderNum;
        }

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }
    }
}

